/*
 * Decompiled with CFR 0.152.
 */
package com.github.crab2died.utils;

import com.github.crab2died.exceptions.IllegalGroupIndexException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegularUtils {
    public static boolean isMatched(String pattern, String reg) {
        Pattern compile = Pattern.compile(reg);
        return compile.matcher(pattern).matches();
    }

    public static List<String> match(String pattern, String reg, int group) {
        ArrayList<String> matchGroups = new ArrayList<String>();
        Pattern compile = Pattern.compile(reg);
        Matcher matcher = compile.matcher(pattern);
        if (group > matcher.groupCount() || group < 0) {
            throw new IllegalGroupIndexException("Illegal match group :" + group);
        }
        while (matcher.find()) {
            matchGroups.add(matcher.group(group));
        }
        return matchGroups;
    }

    public static String match(String pattern, String reg) {
        String match = null;
        List<String> matches = RegularUtils.match(pattern, reg, 0);
        if (null != matches && matches.size() > 0) {
            match = matches.get(0);
        }
        return match;
    }

    public static String converNumByReg(String number) {
        Pattern compile = Pattern.compile("^(\\d+)(\\.0*)?$");
        Matcher matcher = compile.matcher(number);
        while (matcher.find()) {
            number = matcher.group(1);
        }
        return number;
    }
}

