/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.parser.deserializer;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.github.dreamhead.moco.parser.deserializer.TextContainerDeserializerHelper;
import com.github.dreamhead.moco.parser.model.FileContainer;
import com.github.dreamhead.moco.parser.model.TextContainer;
import com.github.dreamhead.moco.util.Strings;
import java.io.IOException;

public final class FileContainerDeserializer
extends JsonDeserializer<FileContainer> {
    private TextContainerDeserializerHelper helper = new TextContainerDeserializerHelper();

    public FileContainer deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken currentToken = jp.getCurrentToken();
        if (currentToken == JsonToken.VALUE_STRING) {
            return FileContainer.asFileContainer(this.helper.text(jp));
        }
        if (currentToken == JsonToken.START_OBJECT) {
            jp.nextToken();
            String target = Strings.strip((String)jp.getText());
            if (this.isForFileContainer(target)) {
                return this.toFileContainer(jp);
            }
            return FileContainer.asFileContainer(this.helper.textContainer(jp, ctxt));
        }
        return (FileContainer)ctxt.handleUnexpectedToken(FileContainer.class, jp);
    }

    private FileContainer toFileContainer(JsonParser jp) throws IOException {
        FileVar file = (FileVar)jp.readValueAs(FileVar.class);
        return file.toFileContainer();
    }

    private boolean isForFileContainer(String target) {
        return "name".equalsIgnoreCase(target) || "charset".equalsIgnoreCase(target);
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    private static class FileVar {
        private TextContainer name;
        private String charset;

        private FileVar() {
        }

        private boolean isAllowedFilename(TextContainer filename) {
            return filename.isRawText() || filename.isForTemplate();
        }

        public FileContainer toFileContainer() {
            if (!this.isAllowedFilename(this.name)) {
                throw new IllegalArgumentException("only string and template are allowed as filename");
            }
            return FileContainer.aFileContainer().withName(this.name).withCharset(this.charset).build();
        }
    }
}

