/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.runner.watcher;

import com.github.dreamhead.moco.MocoException;
import com.github.dreamhead.moco.util.Files;
import com.github.dreamhead.moco.util.Idles;
import com.github.dreamhead.moco.util.MocoExecutors;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WatcherService {
    private static Logger logger = LoggerFactory.getLogger(WatcherService.class);
    private static final long REGISTER_INTERVAL = 1000L;
    private ExecutorService executor = MocoExecutors.executor();
    private WatchService service;
    private boolean running;
    private Multimap<WatchKey, Path> keys = HashMultimap.create();
    private Multimap<Path, Function<File, Void>> listeners = HashMultimap.create();
    private Multimap<Path, Path> directoryToFiles = HashMultimap.create();
    private Map<Path, WatchKey> directoryToKey = Maps.newHashMap();
    private Future<?> result;

    public synchronized void start() throws IOException {
        if (this.running) {
            return;
        }
        this.doStart();
    }

    private void doStart() throws IOException {
        this.service = FileSystems.getDefault().newWatchService();
        this.running = true;
        this.result = this.executor.submit(() -> {
            while (this.running) {
                this.loop();
            }
            this.doStop();
        });
    }

    private void doStop() {
        this.listeners.clear();
        this.keys.clear();
        this.directoryToFiles.clear();
        this.directoryToKey.clear();
    }

    private void loop() {
        try {
            WatchKey key = this.service.take();
            Collection paths = this.keys.get((Object)key);
            List events = key.pollEvents().stream().filter(e -> e.kind().equals(StandardWatchEventKinds.ENTRY_MODIFY)).collect(Collectors.toList());
            for (WatchEvent event : events) {
                Path context = (Path)event.context();
                List contextPaths = paths.stream().filter(p -> p.endsWith(context)).collect(Collectors.toList());
                Iterator iterator = contextPaths.iterator();
                if (!iterator.hasNext()) continue;
                Path path = (Path)iterator.next();
                for (Function listener : this.listeners.get((Object)path)) {
                    listener.apply(path.toFile());
                }
            }
            key.reset();
        }
        catch (ClosedWatchServiceException key) {
        }
        catch (InterruptedException e2) {
            logger.error("Error happens", (Throwable)e2);
        }
    }

    public synchronized void stop() {
        if (this.running) {
            try {
                this.running = false;
                this.service.close();
                this.result.get();
            }
            catch (Exception e) {
                throw new MocoException((Throwable)e);
            }
        }
    }

    public void register(File file, Function<File, Void> listener) {
        Path directory = Files.directoryOf((File)file).toPath();
        WatchKey key = this.registerDirectory(directory);
        Path path = file.toPath();
        this.keys.put((Object)key, (Object)path);
        this.listeners.put((Object)path, listener);
        this.directoryToFiles.put((Object)directory, (Object)path);
        Idles.idle((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private WatchKey registerDirectory(Path directory) {
        if (this.directoryToKey.containsKey(directory)) {
            return this.directoryToKey.get(directory);
        }
        try {
            WatchKey key = directory.register(this.service, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY}, SensitivityWatchEventModifier.HIGH);
            this.directoryToKey.put(directory, key);
            return key;
        }
        catch (IOException e) {
            throw new MocoException((Throwable)e);
        }
    }

    public void unregister(File file) {
        WatchKey key;
        Path path;
        Path directory = Files.directoryOf((File)file).toPath();
        if (!this.directoryToFiles.containsEntry((Object)directory, (Object)(path = file.toPath()))) {
            return;
        }
        this.directoryToFiles.remove((Object)directory, (Object)path);
        if (!this.directoryToFiles.containsKey((Object)directory) && (key = this.directoryToKey.remove(directory)) != null) {
            key.cancel();
        }
        if (this.directoryToFiles.isEmpty()) {
            this.stop();
        }
    }
}

