/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.NodeExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.Platform;
import com.github.eirslett.maven.plugins.frontend.lib.Utils;
import java.io.File;

final class InstallNodeExecutorConfig
implements NodeExecutorConfig {
    private static final String NODE_WINDOWS = "/node".replaceAll("/", "\\\\") + "\\node.exe";
    private static final String NODE_DEFAULT = "/node/node";
    private static final String NPM = "/node/node_modules/npm/bin/npm-cli.js";
    private final InstallConfig installConfig;

    public InstallNodeExecutorConfig(InstallConfig installConfig) {
        this.installConfig = installConfig;
    }

    @Override
    public File getNodePath() {
        String nodeExecutable = this.getPlatform().isWindows() ? NODE_WINDOWS : NODE_DEFAULT;
        return new File(this.installConfig.getInstallDirectory() + nodeExecutable);
    }

    @Override
    public File getNpmPath() {
        return new File(this.installConfig.getInstallDirectory() + Utils.normalize(NPM));
    }

    @Override
    public File getWorkingDirectory() {
        return this.installConfig.getWorkingDirectory();
    }

    @Override
    public Platform getPlatform() {
        return this.installConfig.getPlatform();
    }
}

