/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractionException;
import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractor;
import com.github.eirslett.maven.plugins.frontend.lib.CacheDescriptor;
import com.github.eirslett.maven.plugins.frontend.lib.DownloadException;
import com.github.eirslett.maven.plugins.frontend.lib.FileDownloader;
import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallYarnExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.ProcessExecutionException;
import com.github.eirslett.maven.plugins.frontend.lib.YarnExecutor;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnInstaller {
    public static final String INSTALL_PATH = "/node/yarn";
    public static final String DEFAULT_YARN_DOWNLOAD_ROOT = "https://github.com/yarnpkg/yarn/releases/download/";
    private static final Object LOCK = new Object();
    private String yarnVersion;
    private String yarnDownloadRoot;
    private String userName;
    private String password;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InstallConfig config;
    private final ArchiveExtractor archiveExtractor;
    private final FileDownloader fileDownloader;

    YarnInstaller(InstallConfig config, ArchiveExtractor archiveExtractor, FileDownloader fileDownloader) {
        this.config = config;
        this.archiveExtractor = archiveExtractor;
        this.fileDownloader = fileDownloader;
    }

    public YarnInstaller setYarnVersion(String yarnVersion) {
        this.yarnVersion = yarnVersion;
        return this;
    }

    public YarnInstaller setYarnDownloadRoot(String yarnDownloadRoot) {
        this.yarnDownloadRoot = yarnDownloadRoot;
        return this;
    }

    public YarnInstaller setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public YarnInstaller setPassword(String password) {
        this.password = password;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install() throws InstallationException {
        Object object = LOCK;
        synchronized (object) {
            if (this.yarnDownloadRoot == null || this.yarnDownloadRoot.isEmpty()) {
                this.yarnDownloadRoot = DEFAULT_YARN_DOWNLOAD_ROOT;
            }
            if (!this.yarnIsAlreadyInstalled()) {
                if (!this.yarnVersion.startsWith("v")) {
                    throw new InstallationException("Yarn version has to start with prefix 'v'.");
                }
                this.installYarn();
            }
        }
    }

    private boolean yarnIsAlreadyInstalled() {
        try {
            InstallYarnExecutorConfig executorConfig = new InstallYarnExecutorConfig(this.config);
            File nodeFile = executorConfig.getYarnPath();
            if (nodeFile.exists()) {
                String version = new YarnExecutor(executorConfig, Arrays.asList("--version"), null).executeAndGetResult().trim();
                if (version.equals(this.yarnVersion.replaceFirst("^v", ""))) {
                    this.logger.info("Yarn {} is already installed.", (Object)version);
                    return true;
                }
                this.logger.info("Yarn {} was installed, but we need version {}", (Object)version, (Object)this.yarnVersion);
                return false;
            }
            return false;
        }
        catch (ProcessExecutionException e) {
            return false;
        }
    }

    private void installYarn() throws InstallationException {
        try {
            this.logger.info("Installing Yarn version {}", (Object)this.yarnVersion);
            String downloadUrl = this.yarnDownloadRoot + this.yarnVersion;
            String fileending = "/yarn-" + this.yarnVersion + ".tar.gz";
            downloadUrl = downloadUrl + fileending;
            CacheDescriptor cacheDescriptor = new CacheDescriptor("yarn", this.yarnVersion, fileending);
            File archive = this.config.getCacheResolver().resolve(cacheDescriptor);
            this.downloadFileIfMissing(downloadUrl, archive, this.userName, this.password);
            File installDirectory = this.getInstallDirectory();
            try {
                if (installDirectory.isDirectory()) {
                    FileUtils.deleteDirectory((File)installDirectory);
                }
            }
            catch (IOException e) {
                this.logger.warn("Failed to delete existing Yarn installation.");
            }
            this.extractFile(archive, installDirectory);
            this.logger.info("Installed Yarn locally.");
        }
        catch (DownloadException e) {
            throw new InstallationException("Could not download Yarn", e);
        }
        catch (ArchiveExtractionException e) {
            throw new InstallationException("Could not extract the Yarn archive", e);
        }
    }

    private File getInstallDirectory() {
        File installDirectory = new File(this.config.getInstallDirectory(), INSTALL_PATH);
        if (!installDirectory.exists()) {
            this.logger.debug("Creating install directory {}", (Object)installDirectory);
            installDirectory.mkdirs();
        }
        return installDirectory;
    }

    private void extractFile(File archive, File destinationDirectory) throws ArchiveExtractionException {
        this.logger.info("Unpacking {} into {}", (Object)archive, (Object)destinationDirectory);
        this.archiveExtractor.extract(archive.getPath(), destinationDirectory.getPath());
    }

    private void downloadFileIfMissing(String downloadUrl, File destination, String userName, String password) throws DownloadException {
        if (!destination.exists()) {
            this.downloadFile(downloadUrl, destination, userName, password);
        }
    }

    private void downloadFile(String downloadUrl, File destination, String userName, String password) throws DownloadException {
        this.logger.info("Downloading {} to {}", (Object)downloadUrl, (Object)destination);
        this.fileDownloader.download(downloadUrl, destination.getPath(), userName, password);
    }
}

