/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering;

import java.io.Serializable;
import java.util.LinkedList;
import smile.clustering.FastPair;
import smile.clustering.linkage.Linkage;
import smile.clustering.linkage.UPGMCLinkage;
import smile.clustering.linkage.WPGMCLinkage;
import smile.clustering.linkage.WardLinkage;
import smile.sort.IntHeapSelect;

public class HierarchicalClustering
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int[][] merge;
    private double[] height;

    public HierarchicalClustering(Linkage linkage) {
        int i;
        double[][] proximity = linkage.getProximity();
        int n = proximity.length;
        this.merge = new int[n - 1][2];
        int[] id = new int[n];
        this.height = new double[n - 1];
        int[] points = new int[n];
        for (int i2 = 0; i2 < n; ++i2) {
            points[i2] = i2;
            id[i2] = i2;
        }
        FastPair fp = new FastPair(points, proximity);
        for (i = 0; i < n - 1; ++i) {
            this.height[i] = fp.getNearestPair(this.merge[i]);
            linkage.merge(this.merge[i][0], this.merge[i][1]);
            fp.remove(this.merge[i][1]);
            fp.updatePoint(this.merge[i][0]);
            int p = this.merge[i][0];
            int q = this.merge[i][1];
            this.merge[i][0] = Math.min(id[p], id[q]);
            this.merge[i][1] = Math.max(id[p], id[q]);
            id[p] = n + i;
        }
        if (linkage instanceof UPGMCLinkage || linkage instanceof WPGMCLinkage || linkage instanceof WardLinkage) {
            for (i = 0; i < this.height.length; ++i) {
                this.height[i] = Math.sqrt(this.height[i]);
            }
        }
    }

    public int[][] getTree() {
        return this.merge;
    }

    public double[] getHeight() {
        return this.height;
    }

    public int[] partition(int k) {
        int i;
        int n = this.merge.length + 1;
        int[] membership = new int[n];
        IntHeapSelect heap = new IntHeapSelect(k);
        for (i = 2; i <= k; ++i) {
            heap.add(this.merge[n - i][0]);
            heap.add(this.merge[n - i][1]);
        }
        for (i = 0; i < k; ++i) {
            this.bfs(membership, heap.get(i), i);
        }
        return membership;
    }

    public int[] partition(double h) {
        int k;
        for (int i = 0; i < this.height.length - 1; ++i) {
            if (!(this.height[i] > this.height[i + 1])) continue;
            throw new IllegalStateException("Non-monotonic cluster tree -- the linkage is probably not appropriate!");
        }
        int n = this.merge.length + 1;
        for (k = 2; k <= n && !(this.height[n - k] < h); ++k) {
        }
        if (k <= 2) {
            throw new IllegalArgumentException("The parameter h is too large.");
        }
        return this.partition(k - 1);
    }

    private void bfs(int[] membership, int cluster, int id) {
        int n = this.merge.length + 1;
        LinkedList<Integer> queue = new LinkedList<Integer>();
        queue.offer(cluster);
        Integer i = (Integer)queue.poll();
        while (i != null) {
            if (i < n) {
                membership[i.intValue()] = id;
            } else {
                int m1 = this.merge[i = Integer.valueOf(i - n)][0];
                if (m1 >= n) {
                    queue.offer(m1);
                } else {
                    membership[m1] = id;
                }
                int m2 = this.merge[i][1];
                if (m2 >= n) {
                    queue.offer(m2);
                } else {
                    membership[m2] = id;
                }
            }
            i = (Integer)queue.poll();
        }
    }
}

