/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering.linkage;

import smile.clustering.linkage.Linkage;

public class WardLinkage
extends Linkage {
    private int[] n;

    public WardLinkage(double[][] proximity) {
        this.proximity = proximity;
        this.n = new int[proximity.length];
        for (int i = 0; i < this.n.length; ++i) {
            this.n[i] = 1;
            for (int j = 0; j < i; ++j) {
                double[] dArray = proximity[i];
                int n = j;
                dArray[n] = dArray[n] * proximity[i][j];
            }
        }
    }

    public String toString() {
        return "Ward's linkage";
    }

    @Override
    public void merge(int i, int j) {
        int k;
        double nij = this.n[i] + this.n[j];
        for (k = 0; k < i; ++k) {
            this.proximity[i][k] = (this.proximity[i][k] * (double)(this.n[i] + this.n[k]) + this.proximity[j][k] * (double)(this.n[j] + this.n[k]) - this.proximity[j][i] * (double)this.n[k]) / (nij + (double)this.n[k]);
        }
        for (k = i + 1; k < j; ++k) {
            this.proximity[k][i] = (this.proximity[k][i] * (double)(this.n[i] + this.n[k]) + this.proximity[j][k] * (double)(this.n[j] + this.n[k]) - this.proximity[j][i] * (double)this.n[k]) / (nij + (double)this.n[k]);
        }
        for (k = j + 1; k < this.proximity.length; ++k) {
            this.proximity[k][i] = (this.proximity[k][i] * (double)(this.n[i] + this.n[k]) + this.proximity[k][j] * (double)(this.n[j] + this.n[k]) - this.proximity[j][i] * (double)this.n[k]) / (nij + (double)this.n[k]);
        }
        int n = i;
        this.n[n] = this.n[n] + this.n[j];
    }
}

