/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import smile.data.Attribute;
import smile.data.NumericAttribute;
import smile.feature.Feature;
import smile.math.Math;
import smile.sort.QuickSelect;

public class NumericAttributeFeature
implements Feature<double[]> {
    private Attribute[] attributes;
    private Attribute[] features;
    private int[] map;
    private Scaling scaling;
    private double[] a;
    private double[] b;

    public NumericAttributeFeature(Attribute[] attributes, Scaling scaling) {
        if (scaling != Scaling.NONE && scaling != Scaling.LOGARITHM) {
            throw new IllegalArgumentException("Invalid scaling operation without training data: " + (Object)((Object)scaling));
        }
        this.attributes = attributes;
        this.scaling = scaling;
        int p = 0;
        for (Attribute attribute : attributes) {
            if (!(attribute instanceof NumericAttribute)) continue;
            ++p;
        }
        this.features = new Attribute[p];
        this.map = new int[p];
        int i = 0;
        for (int j = 0; j < attributes.length; ++j) {
            Attribute attribute = attributes[j];
            if (!(attribute instanceof NumericAttribute)) continue;
            this.features[i] = scaling == Scaling.NONE ? attribute : new NumericAttribute(attribute.getName() + "_" + (Object)((Object)scaling), attribute.getDescription(), attribute.getWeight());
            this.map[i++] = j;
        }
    }

    public NumericAttributeFeature(Attribute[] attributes, Scaling scaling, double[][] data) {
        this.attributes = attributes;
        this.scaling = scaling;
        int n = data.length;
        int p = 0;
        for (Attribute attribute : attributes) {
            if (!(attribute instanceof NumericAttribute)) continue;
            ++p;
        }
        this.features = new Attribute[p];
        this.map = new int[p];
        this.a = new double[p];
        this.b = new double[p];
        double[] x = new double[n];
        int i = 0;
        for (int j = 0; j < attributes.length; ++j) {
            Attribute attribute;
            attribute = attributes[j];
            if (!(attribute instanceof NumericAttribute)) continue;
            if (scaling == Scaling.NONE) {
                this.features[i] = attribute;
            } else {
                this.features[i] = new NumericAttribute(attribute.getName() + "_" + (Object)((Object)scaling), attribute.getDescription(), attribute.getWeight());
                if (scaling == Scaling.NORMALIZATION || scaling == Scaling.STANDARDIZATION) {
                    for (int k = 0; k < n; ++k) {
                        x[k] = data[k][j];
                    }
                    if (scaling == Scaling.NORMALIZATION) {
                        this.a[i] = Math.min((double[])x);
                        this.b[i] = Math.max((double[])x) - this.a[i];
                        if (this.b[i] == 0.0) {
                            throw new IllegalArgumentException("Attribute " + attribute + " has constant values.");
                        }
                    }
                    if (scaling == Scaling.STANDARDIZATION) {
                        this.a[i] = Math.mean((double[])x);
                        this.b[i] = Math.sd((double[])x);
                        if (this.b[i] == 0.0) {
                            throw new IllegalArgumentException("Attribute " + attribute + " has constant values.");
                        }
                    }
                }
            }
            this.map[i++] = j;
        }
    }

    public NumericAttributeFeature(Attribute[] attributes, double lower, double upper, double[][] data) {
        if (lower < 0.0 || lower > 0.5) {
            throw new IllegalArgumentException("Invalid lower limit: " + lower);
        }
        if (upper < 0.5 || lower > 1.0) {
            throw new IllegalArgumentException("Invalid upper limit: " + upper);
        }
        if (upper <= lower) {
            throw new IllegalArgumentException("Invalid lower and upper limit pair: " + lower + " >= " + upper);
        }
        this.attributes = attributes;
        this.scaling = Scaling.NORMALIZATION;
        int n = data.length;
        int p = 0;
        for (Attribute attribute : attributes) {
            if (!(attribute instanceof NumericAttribute)) continue;
            ++p;
        }
        int i1 = (int)Math.round((double)(lower * (double)n));
        int i2 = (int)Math.round((double)(upper * (double)n));
        if (i2 == n) {
            i2 = n - 1;
        }
        this.features = new Attribute[p];
        this.map = new int[p];
        this.a = new double[p];
        this.b = new double[p];
        double[] x = new double[n];
        int i = 0;
        for (int j = 0; j < attributes.length; ++j) {
            Attribute attribute = attributes[j];
            if (!(attribute instanceof NumericAttribute)) continue;
            this.features[i] = new NumericAttribute(attribute.getName() + "_" + (Object)((Object)this.scaling), attribute.getDescription(), attribute.getWeight());
            for (int k = 0; k < n; ++k) {
                x[k] = data[k][j];
            }
            this.a[i] = QuickSelect.select((double[])x, (int)i1);
            this.b[i] = QuickSelect.select((double[])x, (int)i2) - this.a[i];
            if (this.b[i] == 0.0) {
                throw new IllegalArgumentException("Attribute " + attribute + " has constant values in the given range.");
            }
            this.map[i++] = j;
        }
    }

    public NumericAttributeFeature(Attribute[] attributes, double[][] data) {
        this.attributes = attributes;
        this.scaling = Scaling.STANDARDIZATION;
        int n = data.length;
        int p = 0;
        for (Attribute attribute : attributes) {
            if (!(attribute instanceof NumericAttribute)) continue;
            ++p;
        }
        this.features = new Attribute[p];
        this.map = new int[p];
        this.a = new double[p];
        this.b = new double[p];
        double[] x = new double[n];
        int i = 0;
        for (int j = 0; j < attributes.length; ++j) {
            Attribute attribute;
            attribute = attributes[j];
            if (!(attribute instanceof NumericAttribute)) continue;
            this.features[i] = new NumericAttribute(attribute.getName() + "_" + (Object)((Object)this.scaling), attribute.getDescription(), attribute.getWeight());
            for (int k = 0; k < n; ++k) {
                x[k] = data[k][j];
            }
            this.a[i] = QuickSelect.median((double[])x);
            this.b[i] = QuickSelect.q3((double[])x) - QuickSelect.q1((double[])x);
            if (this.b[i] == 0.0) {
                throw new IllegalArgumentException("Attribute " + attribute + " has constant values between Q1 and Q3.");
            }
            this.map[i++] = j;
        }
    }

    @Override
    public Attribute[] attributes() {
        return this.features;
    }

    @Override
    public double f(double[] object, int id) {
        if (object.length != this.attributes.length) {
            throw new IllegalArgumentException(String.format("Invalide object size %d, expected %d", object.length, this.attributes.length));
        }
        if (id < 0 || id >= this.features.length) {
            throw new IllegalArgumentException("Invalide feature id: " + id);
        }
        double x = object[this.map[id]];
        switch (this.scaling) {
            case NONE: {
                return x;
            }
            case LOGARITHM: {
                if (x <= 0.0) {
                    throw new IllegalArgumentException("Invalid value for logarithm: " + x);
                }
                return Math.log((double)x);
            }
            case NORMALIZATION: {
                double y = (x - this.a[id]) / this.b[id];
                if (y < 0.0) {
                    y = 0.0;
                }
                if (y > 1.0) {
                    y = 1.0;
                }
                return y;
            }
            case STANDARDIZATION: {
                return (x - this.a[id]) / this.b[id];
            }
        }
        throw new IllegalStateException("Impossible to reach here.");
    }

    public static enum Scaling {
        NONE,
        LOGARITHM,
        NORMALIZATION,
        STANDARDIZATION;

    }
}

