/*
 * Decompiled with CFR 0.152.
 */
package smile.vq;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.clustering.BBDTree;
import smile.clustering.Clustering;
import smile.clustering.HierarchicalClustering;
import smile.clustering.linkage.UPGMALinkage;
import smile.math.Math;
import smile.math.matrix.ColumnMajorMatrix;
import smile.math.matrix.EigenValueDecomposition;
import smile.math.matrix.Matrix;

public class SOM
implements Clustering<double[]> {
    private static final Logger logger = LoggerFactory.getLogger(SOM.class);
    private int width;
    private int height;
    private int d;
    private double[][][] neurons;
    private int[][] bmu;
    private int[][] voronoi;
    private int[] y;
    private double[][] umatrix;

    public SOM(double[][] data, int size) {
        this(data, size, size);
    }

    public SOM(double[][] data, int width, int height) {
        int i;
        int k;
        int i2;
        int i3;
        int i4;
        if (height <= 0 || width <= 0 || height * width == 1) {
            throw new IllegalArgumentException("Invalide map width = " + width + " or height = " + height);
        }
        this.width = width;
        this.height = height;
        this.d = data[0].length;
        int n = data.length;
        this.neurons = new double[height][width][this.d];
        this.bmu = new int[n][2];
        double mpd = Math.max((double)0.5, (double)((double)(height * width) / (double)n));
        int roughTrainLen = (int)Math.ceil((double)(10.0 * mpd));
        int fineTrainLen = (int)Math.ceil((double)(40.0 * mpd));
        int trainLen = roughTrainLen + fineTrainLen;
        double initRadius = Math.max((double)1.0, (double)((double)Math.max((int)height, (int)width) / 2.0));
        double finalRadius = Math.max((double)1.0, (double)(initRadius / 4.0));
        double[] radius = new double[trainLen];
        for (i4 = 0; i4 < roughTrainLen; ++i4) {
            radius[roughTrainLen - i4 - 1] = finalRadius + (double)i4 / (double)(roughTrainLen - 1) * (initRadius - finalRadius);
        }
        initRadius = finalRadius - 1.0 / (double)(fineTrainLen - 1);
        finalRadius = 1.0;
        for (i4 = 0; i4 < fineTrainLen; ++i4) {
            radius[roughTrainLen + fineTrainLen - i4 - 1] = finalRadius + (double)i4 / (double)(fineTrainLen - 1) * (initRadius - finalRadius);
        }
        for (i4 = 0; i4 < trainLen; ++i4) {
            radius[i4] = radius[i4] * radius[i4];
        }
        double[] mu = new double[this.d];
        for (i3 = 0; i3 < n; ++i3) {
            for (int j = 0; j < this.d; ++j) {
                int n2 = j;
                mu[n2] = mu[n2] + data[i3][j];
            }
        }
        i3 = 0;
        while (i3 < this.d) {
            int n3 = i3++;
            mu[n3] = mu[n3] / (double)n;
        }
        ColumnMajorMatrix D = new ColumnMajorMatrix(n, this.d);
        for (int i5 = 0; i5 < n; ++i5) {
            for (int j = 0; j < this.d; ++j) {
                D.set(i5, j, data[i5][j] - mu[j]);
            }
        }
        ColumnMajorMatrix V = new ColumnMajorMatrix(this.d, this.d);
        for (int i6 = 0; i6 < this.d; ++i6) {
            for (int j = i6; j < this.d; ++j) {
                for (int k2 = 0; k2 < n; ++k2) {
                    V.add(i6, j, D.get(k2, i6) * D.get(k2, j));
                }
                V.div(i6, j, (double)n);
                V.set(j, i6, V.get(i6, j));
            }
        }
        EigenValueDecomposition eigen = Math.eigen((Matrix)V, (int)2);
        double[] v1 = new double[this.d];
        double[] v2 = new double[this.d];
        for (i2 = 0; i2 < this.d; ++i2) {
            v1[i2] = eigen.getEigenVectors().get(i2, 0);
            v2[i2] = eigen.getEigenVectors().get(i2, 1);
        }
        for (i2 = 0; i2 < height; ++i2) {
            double w = (double)i2 / (double)height - 0.5;
            for (int j = 0; j < width; ++j) {
                double h = (double)j / (double)width - 0.5;
                for (k = 0; k < this.d; ++k) {
                    this.neurons[i2][j][k] = mu[k] + w * v1[k] + h * v2[k];
                }
            }
        }
        BBDTree bbd = new BBDTree(data);
        double[][] centroids = new double[width * height][];
        double[][] sums = new double[width * height][this.d];
        int[] hit = new int[width * height];
        int[] sy = new int[n];
        k = 0;
        for (i = 0; i < height; ++i) {
            int j = 0;
            while (j < width) {
                centroids[k] = this.neurons[i][j];
                ++j;
                ++k;
            }
        }
        for (int iter = 0; iter < trainLen; ++iter) {
            int r = (int)Math.round((double)Math.sqrt((double)radius[iter]));
            double distortion = bbd.clustering(centroids, sums, hit, sy);
            logger.info(String.format("SOM distortion after %3d iterations (radius = %d): %.5f", iter + 1, r, distortion));
            for (int i7 = 0; i7 < height; ++i7) {
                for (int j = 0; j < width; ++j) {
                    int pos;
                    int t;
                    int s;
                    double denom = 0.0;
                    Arrays.fill(this.neurons[i7][j], 0.0);
                    int minH = Math.max((int)0, (int)(i7 - 3 * r)) + 1;
                    int maxH = Math.min((int)height, (int)(i7 + 3 * r)) - 1;
                    int minW = Math.max((int)0, (int)(j - 3 * r)) + 1;
                    int maxW = Math.min((int)width, (int)(j + 3 * r)) - 1;
                    int hits = 0;
                    while (hits == 0) {
                        minH = Math.max((int)0, (int)(minH - 1));
                        maxH = Math.min((int)height, (int)(maxH + 1));
                        minW = Math.max((int)0, (int)(minW - 1));
                        maxW = Math.min((int)width, (int)(maxW + 1));
                        for (s = minH; s < maxH; ++s) {
                            for (t = minW; t < maxW; ++t) {
                                pos = s * width + t;
                                hits += hit[pos];
                            }
                        }
                    }
                    for (s = minH; s < maxH; ++s) {
                        for (t = minW; t < maxW; ++t) {
                            pos = s * width + t;
                            if (hit[pos] <= 0) continue;
                            int dx = i7 - s;
                            int dy = j - t;
                            double h = Math.exp((double)((double)(-(dx * dx + dy * dy)) / (2.0 * radius[iter])));
                            denom += h * (double)hit[pos];
                            for (int k3 = 0; k3 < this.d; ++k3) {
                                double[] dArray = this.neurons[i7][j];
                                int n4 = k3;
                                dArray[n4] = dArray[n4] + h * sums[pos][k3];
                            }
                        }
                    }
                    int k4 = 0;
                    while (k4 < this.d) {
                        double[] dArray = this.neurons[i7][j];
                        int n5 = k4++;
                        dArray[n5] = dArray[n5] / denom;
                    }
                }
            }
        }
        for (i = 0; i < n; ++i) {
            this.bmu[i][0] = sy[i] / width;
            this.bmu[i][1] = sy[i] % width;
        }
        this.voronoi = new int[height][width];
        this.voronoi = new int[height][width];
        for (i = 0; i < this.bmu.length; ++i) {
            int[] nArray = this.voronoi[this.bmu[i][0]];
            int n6 = this.bmu[i][1];
            nArray[n6] = nArray[n6] + 1;
        }
        this.umatrix = new double[height][width];
        for (i = 0; i < height - 1; ++i) {
            for (int j = 0; j < width - 1; ++j) {
                double dist = Math.sqrt((double)Math.squaredDistance((double[])this.neurons[i][j], (double[])this.neurons[i][j + 1]));
                this.umatrix[i][j] = Math.max((double)this.umatrix[i][j], (double)dist);
                this.umatrix[i][j + 1] = Math.max((double)this.umatrix[i][j + 1], (double)dist);
                dist = Math.sqrt((double)Math.squaredDistance((double[])this.neurons[i][j], (double[])this.neurons[i + 1][j]));
                this.umatrix[i][j] = Math.max((double)this.umatrix[i][j], (double)dist);
                this.umatrix[i + 1][j] = Math.max((double)this.umatrix[i + 1][j], (double)dist);
            }
        }
        for (i = 0; i < height - 1; ++i) {
            double dist = Math.sqrt((double)Math.squaredDistance((double[])this.neurons[i][width - 1], (double[])this.neurons[i + 1][width - 1]));
            this.umatrix[i][width - 1] = Math.max((double)this.umatrix[i][width - 1], (double)dist);
            this.umatrix[i + 1][width - 1] = Math.max((double)this.umatrix[i + 1][width - 1], (double)dist);
        }
        for (int j = 0; j < width - 1; ++j) {
            double dist = Math.sqrt((double)Math.squaredDistance((double[])this.neurons[height - 1][j], (double[])this.neurons[height - 1][j + 1]));
            this.umatrix[height - 1][j] = Math.max((double)this.umatrix[height - 1][j], (double)dist);
            this.umatrix[height - 1][j + 1] = Math.max((double)this.umatrix[height - 1][j + 1], (double)dist);
        }
        this.umatrix[height - 1][width - 1] = Math.max((double)this.umatrix[height - 1][width - 2], (double)this.umatrix[height - 2][width - 1]);
    }

    public double[][][] map() {
        return this.neurons;
    }

    public double[][] umatrix() {
        return this.umatrix;
    }

    public int[][] bmu() {
        return this.bmu;
    }

    public int[][] size() {
        return this.voronoi;
    }

    public int[][] getClusterLabel() {
        if (this.y == null) {
            throw new IllegalStateException("Neuron cluster labels are not available. Call partition() first.");
        }
        int[][] clusterLabels = new int[this.height][this.width];
        boolean l = false;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                clusterLabels[i][j] = this.y[i * this.width + j];
            }
        }
        return clusterLabels;
    }

    public int[] partition(int k) {
        int j;
        int n = this.width * this.height;
        double[][] units = new double[n][this.d];
        int l = 0;
        for (int i = 0; i < this.height; ++i) {
            j = 0;
            while (j < this.width) {
                units[l] = this.neurons[i][j];
                ++j;
                ++l;
            }
        }
        double[][] proximity = new double[n][];
        for (int i = 0; i < n; ++i) {
            proximity[i] = new double[i + 1];
            for (j = 0; j < i; ++j) {
                proximity[i][j] = Math.distance((double[])units[i], (double[])units[j]);
            }
        }
        UPGMALinkage linkage = new UPGMALinkage(proximity);
        HierarchicalClustering hc = new HierarchicalClustering(linkage);
        this.y = hc.partition(k);
        int[] cluster = new int[this.bmu.length];
        for (int i = 0; i < cluster.length; ++i) {
            cluster[i] = this.y[this.bmu[i][0] * this.width + this.bmu[i][1]];
        }
        return cluster;
    }

    @Override
    public int predict(double[] x) {
        double best = Double.MAX_VALUE;
        int ii = -1;
        int jj = -1;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                double dist = Math.squaredDistance((double[])this.neurons[i][j], (double[])x);
                if (!(dist < best)) continue;
                best = dist;
                ii = i;
                jj = j;
            }
        }
        if (this.y == null) {
            return ii * this.width + jj;
        }
        return this.y[ii * this.width + jj];
    }

    public static class Neuron {
        public double[] w;
        public int cluster;
        public int[] samples;
        public int y;
        public int[] ni;
        public double[] distance;
    }
}

