/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.lang;

import com.github.houbb.heaven.support.handler.IHandler;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassTypeUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassUtil;
import com.github.houbb.heaven.util.lang.reflect.ReflectFieldUtil;
import com.github.houbb.heaven.util.util.ArrayPrimitiveUtil;
import com.github.houbb.heaven.util.util.ArrayUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.heaven.util.util.MapUtil;
import com.github.houbb.heaven.util.util.regex.RegexUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ObjectUtil {
    private ObjectUtil() {
    }

    public static boolean isSameType(Object one, Object two) {
        if (ObjectUtil.isNull(one) || ObjectUtil.isNull(two)) {
            return false;
        }
        Class<?> clazzOne = one.getClass();
        return clazzOne.isInstance(two);
    }

    public static boolean isNotSameType(Object one, Object two) {
        return !ObjectUtil.isSameType(one, two);
    }

    public static boolean isNull(Object object) {
        return null == object;
    }

    public static boolean isNotNull(Object object) {
        return !ObjectUtil.isNull(object);
    }

    public static boolean isEmpty(Object object) {
        if (ObjectUtil.isNull(object)) {
            return true;
        }
        if (object instanceof String) {
            String string = (String)object;
            return StringUtil.isEmpty(string);
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            return CollectionUtil.isEmpty(collection);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return MapUtil.isEmpty(map);
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object) == 0;
        }
        return false;
    }

    public static boolean isNotEmpty(Object object) {
        return !ObjectUtil.isEmpty(object);
    }

    public static boolean isEquals(Object except, Object real) {
        if (ObjectUtil.isNotSameType(except, real)) {
            return false;
        }
        Class<?> exceptClass = except.getClass();
        Class<?> realClass = except.getClass();
        if (exceptClass.isPrimitive() && realClass.isPrimitive() && except != real) {
            return false;
        }
        if (ClassTypeUtil.isArray(exceptClass) && ClassTypeUtil.isArray(realClass)) {
            Object[] exceptArray = (Object[])except;
            Object[] realArray = (Object[])real;
            return Arrays.equals(exceptArray, realArray);
        }
        if (ClassTypeUtil.isMap(exceptClass) && ClassTypeUtil.isMap(realClass)) {
            Map exceptMap = (Map)except;
            Map realMap = (Map)real;
            return exceptMap.equals(realMap);
        }
        return except.equals(real);
    }

    public static boolean isNotEquals(Object except, Object real) {
        return !ObjectUtil.isEquals(except, real);
    }

    public static String objectToString(Object object) {
        return ObjectUtil.objectToString(object, null);
    }

    public static String objectToString(Object object, String defaultValue) {
        if (ObjectUtil.isNull(object)) {
            return defaultValue;
        }
        return object.toString();
    }

    public static boolean isNull(Object object, Object ... others) {
        if (ObjectUtil.isNull(object)) {
            if (ArrayUtil.isNotEmpty(others)) {
                for (Object other : others) {
                    if (!ObjectUtil.isNotNull(other)) continue;
                    return false;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public static boolean isEqualsOrNull(Object left, Object right) {
        if (ObjectUtil.isNull(left, right)) {
            return true;
        }
        if (ObjectUtil.isNull(left) || ObjectUtil.isNull(right)) {
            return false;
        }
        return ObjectUtil.isEquals(left, right);
    }

    public static <R> List<R> toList(Object object, IHandler<Object, R> handler) {
        if (ObjectUtil.isNull(object)) {
            return Collections.emptyList();
        }
        Class<?> clazz = object.getClass();
        if (ClassTypeUtil.isCollection(clazz)) {
            Collection collection = (Collection)object;
            return CollectionUtil.toList(collection, handler);
        }
        if (clazz.isArray()) {
            return ArrayUtil.toList(object, handler);
        }
        throw new UnsupportedOperationException("Not support foreach() for class: " + clazz.getName());
    }

    public static Class getClass(Object object) {
        if (ObjectUtil.isNull(object)) {
            return null;
        }
        return object.getClass();
    }

    public static void emptyToNull(Object object) {
        if (null == object) {
            return;
        }
        List<Field> fieldList = ClassUtil.getAllFieldList(object.getClass());
        for (Field field : fieldList) {
            Object value = ReflectFieldUtil.getValue(field, object);
            if (!ObjectUtil.isEmpty(value)) continue;
            ReflectFieldUtil.setValue(field, object, null);
        }
    }

    public static void copyProperties(Object source, Object target) {
        if (source == null || target == null) {
            return;
        }
        Map<String, Field> sourceFieldMap = ClassUtil.getAllFieldMap(source.getClass());
        Map<String, Field> targetFieldMap = ClassUtil.getAllFieldMap(target.getClass());
        for (Map.Entry<String, Field> entry : sourceFieldMap.entrySet()) {
            String sourceFieldName = entry.getKey();
            Field sourceField = entry.getValue();
            Field targetField = targetFieldMap.get(sourceFieldName);
            if (targetField == null || !ClassUtil.isAssignable(sourceField.getType(), targetField.getType())) continue;
            Object sourceVal = ReflectFieldUtil.getValue(sourceField, source);
            ReflectFieldUtil.setValue(targetField, target, sourceVal);
        }
    }

    public static boolean isSameValue(Object valueOne, Object valueTwo) {
        if (valueOne == null && valueTwo == null) {
            return true;
        }
        if (valueOne == null || valueTwo == null) {
            return false;
        }
        return valueOne.equals(valueTwo);
    }

    public static int getMaxFieldSize(Object object) {
        if (object == null) {
            return 0;
        }
        Class<?> clazzType = object.getClass();
        if (!ClassTypeUtil.isJavaBean(clazzType)) {
            return 1;
        }
        int max = 1;
        List<Field> fieldList = ClassUtil.getAllFieldList(clazzType);
        for (Field field : fieldList) {
            try {
                Object fieldValue = field.get(object);
                int size = ObjectUtil.getObjectCollectionSize(fieldValue);
                max = Math.max(max, size);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return max;
    }

    public static int getObjectCollectionSize(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            return collection.size();
        }
        if (object instanceof Object[]) {
            Object[] objects = (Object[])object;
            return objects.length;
        }
        if (object instanceof boolean[]) {
            boolean[] booleans = (boolean[])object;
            return booleans.length;
        }
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            return bytes.length;
        }
        if (object instanceof short[]) {
            short[] shorts = (short[])object;
            return shorts.length;
        }
        if (object instanceof int[]) {
            int[] ints = (int[])object;
            return ints.length;
        }
        if (object instanceof long[]) {
            long[] longs = (long[])object;
            return longs.length;
        }
        if (object instanceof float[]) {
            float[] floats = (float[])object;
            return floats.length;
        }
        if (object instanceof double[]) {
            double[] doubles = (double[])object;
            return doubles.length;
        }
        if (object instanceof char[]) {
            char[] chars = (char[])object;
            return chars.length;
        }
        return 1;
    }

    public static Object getValueByPath(Object object, String path) {
        if (object == null || StringUtil.isEmpty(path)) {
            return null;
        }
        String[] pathSegments = path.split("\\.");
        Object currentObject = object;
        for (String segment : pathSegments) {
            if (currentObject == null) {
                return null;
            }
            currentObject = ReflectFieldUtil.getValue(segment, currentObject);
        }
        return currentObject;
    }

    public static Object getValueByPath(Map<String, ?> map, String path) {
        if (MapUtil.isEmpty(map) || StringUtil.isEmpty(path)) {
            return null;
        }
        String[] pathSegments = path.split("\\.");
        Map<String, Object> currentObject = map;
        for (String segment : pathSegments) {
            if (currentObject == null || !(currentObject instanceof Map)) {
                return null;
            }
            Map<String, ?> currentMap = currentObject;
            currentObject = currentMap.get(segment);
        }
        return currentObject;
    }

    public static boolean gt(Object leftVal, Object rightVal) {
        if (leftVal instanceof Comparable && rightVal instanceof Comparable) {
            Comparable leftC = (Comparable)leftVal;
            Comparable rightC = (Comparable)rightVal;
            return leftC.compareTo(rightC) > 0;
        }
        return false;
    }

    public static boolean gte(Object leftVal, Object rightVal) {
        if (leftVal instanceof Comparable && rightVal instanceof Comparable) {
            Comparable leftC = (Comparable)leftVal;
            Comparable rightC = (Comparable)rightVal;
            return leftC.compareTo(rightC) >= 0;
        }
        return false;
    }

    public static boolean lt(Object leftVal, Object rightVal) {
        if (leftVal instanceof Comparable && rightVal instanceof Comparable) {
            Comparable leftC = (Comparable)leftVal;
            Comparable rightC = (Comparable)rightVal;
            return leftC.compareTo(rightC) < 0;
        }
        return false;
    }

    public static boolean lte(Object leftVal, Object rightVal) {
        if (leftVal instanceof Comparable && rightVal instanceof Comparable) {
            Comparable leftC = (Comparable)leftVal;
            Comparable rightC = (Comparable)rightVal;
            return leftC.compareTo(rightC) <= 0;
        }
        return false;
    }

    public static boolean contains(Object leftVal, Object rightVal) {
        if (leftVal == null) {
            return false;
        }
        if (leftVal instanceof String && rightVal instanceof String) {
            String leftStr = (String)leftVal;
            String rightStr = (String)leftVal;
            return leftStr.contains(rightStr);
        }
        if (leftVal instanceof Collection) {
            Collection leftColl = (Collection)leftVal;
            return CollectionUtil.contains(leftColl, rightVal);
        }
        if (leftVal instanceof Object[]) {
            Object[] array = (Object[])leftVal;
            return ArrayUtil.contains(array, rightVal);
        }
        if (leftVal instanceof boolean[] && rightVal instanceof Boolean) {
            boolean[] arrays = (boolean[])leftVal;
            Boolean rightP = (Boolean)rightVal;
            return ArrayPrimitiveUtil.contains(arrays, rightP);
        }
        if (leftVal instanceof byte[] && rightVal instanceof Byte) {
            byte[] arrays = (byte[])leftVal;
            Byte rightP = (Byte)rightVal;
            return ArrayPrimitiveUtil.contains(arrays, rightP);
        }
        if (leftVal instanceof short[] && rightVal instanceof Short) {
            short[] arrays = (short[])leftVal;
            Short rightP = (Short)rightVal;
            return ArrayPrimitiveUtil.contains(arrays, rightP);
        }
        if (leftVal instanceof int[] && rightVal instanceof Integer) {
            int[] arrays = (int[])leftVal;
            Integer rightP = (Integer)rightVal;
            return ArrayPrimitiveUtil.contains(arrays, rightP);
        }
        if (leftVal instanceof long[] && rightVal instanceof Long) {
            long[] arrays = (long[])leftVal;
            Long rightP = (Long)rightVal;
            return ArrayPrimitiveUtil.contains(arrays, rightP);
        }
        if (leftVal instanceof float[] && rightVal instanceof Float) {
            float[] arrays = (float[])leftVal;
            Float rightP = (Float)rightVal;
            return ArrayPrimitiveUtil.contains(arrays, rightP.floatValue());
        }
        if (leftVal instanceof double[] && rightVal instanceof Double) {
            double[] arrays = (double[])leftVal;
            Double rightP = (Double)rightVal;
            return ArrayPrimitiveUtil.contains(arrays, rightP);
        }
        if (leftVal instanceof char[] && rightVal instanceof Character) {
            char[] arrays = (char[])leftVal;
            Character rightP = (Character)rightVal;
            return ArrayPrimitiveUtil.contains(arrays, rightP.charValue());
        }
        return false;
    }

    public static boolean startWith(Object leftVal, Object rightVal) {
        if (leftVal == null || rightVal == null) {
            return false;
        }
        if (leftVal instanceof String && rightVal instanceof String) {
            String leftStr = (String)leftVal;
            String rightStr = (String)rightVal;
            return leftStr.startsWith(rightStr);
        }
        String leftStr = leftVal.toString();
        String rightStr = rightVal.toString();
        return leftStr.startsWith(rightStr);
    }

    public static boolean endWith(Object leftVal, Object rightVal) {
        if (leftVal == null || rightVal == null) {
            return false;
        }
        if (leftVal instanceof String && rightVal instanceof String) {
            String leftStr = (String)leftVal;
            String rightStr = (String)rightVal;
            return leftStr.endsWith(rightStr);
        }
        String leftStr = leftVal.toString();
        String rightStr = rightVal.toString();
        return leftStr.endsWith(rightStr);
    }

    public static boolean matchRegex(Object value, String regex) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            String string = (String)value;
            return RegexUtil.match(regex, string);
        }
        String text = value.toString();
        return RegexUtil.match(text, regex);
    }
}

