/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.lang;

import com.github.houbb.heaven.util.lang.StringUtil;
import java.util.regex.Pattern;

public final class SpecialCharUtil {
    private static final Pattern PUNCTUATION_PATTERN = Pattern.compile("\\p{P}");
    private static final String EMOJI_PATTERN_STR = "(?:[\\uD83C\\uDF00-\\uD83D\\uDDFF]|[\\uD83E\\uDD00-\\uD83E\\uDDFF]|[\\uD83D\\uDE00-\\uD83D\\uDE4F]|[\\uD83D\\uDE80-\\uD83D\\uDEFF]|[\\u2600-\\u26FF]\\uFE0F?|[\\u2700-\\u27BF]\\uFE0F?|\\u24C2\\uFE0F?|[\\uD83C\\uDDE6-\\uD83C\\uDDFF]{1,2}|[\\uD83C\\uDD70\\uD83C\\uDD71\\uD83C\\uDD7E\\uD83C\\uDD7F\\uD83C\\uDD8E\\uD83C\\uDD91-\\uD83C\\uDD9A]\\uFE0F?|[\\u0023\\u002A\\u0030-\\u0039]\\uFE0F?\\u20E3|[\\u2194-\\u2199\\u21A9-\\u21AA]\\uFE0F?|[\\u2B05-\\u2B07\\u2B1B\\u2B1C\\u2B50\\u2B55]\\uFE0F?|[\\u2934\\u2935]\\uFE0F?|[\\u3030\\u303D]\\uFE0F?|[\\u3297\\u3299]\\uFE0F?|[\\uD83C\\uDE01\\uD83C\\uDE02\\uD83C\\uDE1A\\uD83C\\uDE2F\\uD83C\\uDE32-\\uD83C\\uDE3A\\uD83C\\uDE50\\uD83C\\uDE51]\\uFE0F?|[\\u203C\\u2049]\\uFE0F?|[\\u25AA\\u25AB\\u25B6\\u25C0\\u25FB-\\u25FE]\\uFE0F?|[\\u00A9\\u00AE]\\uFE0F?|[\\u2122\\u2139]\\uFE0F?|\\uD83C\\uDC04\\uFE0F?|\\uD83C\\uDCCF\\uFE0F?|[\\u231A\\u231B\\u2328\\u23CF\\u23E9-\\u23F3\\u23F8-\\u23FA]\\uFE0F?)";
    private static final String SPECIAL_CHARS = "\u2260\u2261\u2044\u2264\u2265\u00ab#\u00a9\u00a8!\u00af&\u00ae'$\u00ac%\u00a3*+\u00a2\u00a1(\u2248)\u00a7./\u00a6\u00a5,\u00bb\u00b8\u00be\u00bf\u00bc\u00bd;:\u00b0\u00b1\u00b6?\u00b7>=\u00b4<@\u2660\u2190\u2191\u2192\u2663\u2193\u2194\u2665\u2229\u2666\u222b\u2013\u2014\u201a\u2019\u00d7\u2018^\u201e\u201d\u25ca\u201c\u2020\u2021\u2022\u2202\u20ac\u2026\u220f\u2122\u2030\u2033\u2032\u02dc\u2212\u2211\u2039\u221e\u00f7~|\u203a\u221a\u203e\uffe5`\ufe0f";

    private SpecialCharUtil() {
    }

    public static String filterSpecial(String string) {
        if (StringUtil.isEmpty(string)) {
            return string;
        }
        String trimEmoji = string.replaceAll(EMOJI_PATTERN_STR, "");
        char[] chars = trimEmoji.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : chars) {
            String cStr = String.valueOf(c);
            if ("-".equals(cStr) || "_".equals(cStr)) {
                stringBuilder.append(c);
                continue;
            }
            if (SpecialCharUtil.isSpecialChar(cStr) || SpecialCharUtil.isPunctuation(cStr)) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static boolean isSpecialChar(String string) {
        return SPECIAL_CHARS.contains(string);
    }

    private static boolean isPunctuation(String string) {
        return PUNCTUATION_PATTERN.matcher(string).find();
    }
}

