/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.junitperf.core.jupiter.context;

import com.github.houbb.heaven.util.util.DateUtil;
import com.github.houbb.junitperf.core.annotation.JunitPerfConfig;
import com.github.houbb.junitperf.core.annotation.JunitPerfRequire;
import com.github.houbb.junitperf.core.report.Reporter;
import com.github.houbb.junitperf.core.statistics.StatisticsCalculator;
import com.github.houbb.junitperf.model.evaluation.EvaluationContext;
import com.github.houbb.junitperf.support.exception.JunitPerfRuntimeException;
import com.github.houbb.junitperf.support.statements.PerformanceEvaluationStatement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;

@API(status=API.Status.INTERNAL, since="2_0_0")
public class PerfConfigContext
implements TestTemplateInvocationContext {
    private static final ConcurrentHashMap<Class, List<EvaluationContext>> ACTIVE_CONTEXTS = new ConcurrentHashMap();
    private final Method method;
    private JunitPerfConfig perfConfig;
    private JunitPerfRequire perfRequire;

    public PerfConfigContext(ExtensionContext context) {
        this.method = context.getRequiredTestMethod();
        this.perfConfig = this.method.getAnnotation(JunitPerfConfig.class);
        this.perfRequire = this.method.getAnnotation(JunitPerfRequire.class);
    }

    public List<Extension> getAdditionalExtensions() {
        return Collections.singletonList((testInstance, context) -> {
            Class<?> clazz = testInstance.getClass();
            ACTIVE_CONTEXTS.putIfAbsent(clazz, new ArrayList());
            EvaluationContext evaluationContext = new EvaluationContext(testInstance, this.method, DateUtil.getCurrentDateTimeStr());
            evaluationContext.loadConfig(this.perfConfig);
            evaluationContext.loadRequire(this.perfRequire);
            StatisticsCalculator statisticsCalculator = this.perfConfig.statistics().newInstance();
            Set<Reporter> reporterSet = this.getReporterSet();
            ACTIVE_CONTEXTS.get(clazz).add(evaluationContext);
            try {
                new PerformanceEvaluationStatement(evaluationContext, statisticsCalculator, reporterSet, (Collection<EvaluationContext>)ACTIVE_CONTEXTS.get(clazz), clazz).evaluate();
            }
            catch (Throwable throwable) {
                throw new JunitPerfRuntimeException(throwable);
            }
        });
    }

    private Set<Reporter> getReporterSet() {
        Class<? extends Reporter>[] reporters;
        HashSet<Reporter> reporterSet = new HashSet<Reporter>();
        for (Class<? extends Reporter> clazz : reporters = this.perfConfig.reporter()) {
            try {
                Reporter reporter = clazz.newInstance();
                reporterSet.add(reporter);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new JunitPerfRuntimeException(e);
            }
        }
        return reporterSet;
    }
}

