/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.junitperf.support.builder;

import com.github.houbb.heaven.support.builder.IBuilder;
import com.github.houbb.junitperf.core.statistics.StatisticsCalculator;
import com.github.houbb.junitperf.model.evaluation.component.EvaluationConfig;
import com.github.houbb.junitperf.model.evaluation.component.EvaluationRequire;
import com.github.houbb.junitperf.model.evaluation.component.EvaluationResult;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class EvaluationResultBuilder
implements IBuilder<EvaluationResult> {
    private final EvaluationConfig evaluationConfig;
    private final EvaluationRequire evaluationRequire;
    private final StatisticsCalculator statisticsCalculator;

    public EvaluationResultBuilder(EvaluationConfig evaluationConfig, EvaluationRequire evaluationRequire, StatisticsCalculator statisticsCalculator) {
        this.evaluationConfig = evaluationConfig;
        this.evaluationRequire = evaluationRequire;
        this.statisticsCalculator = statisticsCalculator;
    }

    public EvaluationResult build() {
        EvaluationResult evaluationResult = new EvaluationResult();
        evaluationResult.setMinAchieved(this.isMinAchieved());
        evaluationResult.setMaxAchieved(this.isMaxAchieved());
        evaluationResult.setAverageAchieved(this.isAverageAchieved());
        evaluationResult.setTimesPerSecondAchieved(this.isTimesPerSecondAchieved());
        Map<Integer, Boolean> isPercentilesAchievedMap = this.buildIsPercentilesAchievedMap();
        evaluationResult.setIsPercentilesAchievedMap(isPercentilesAchievedMap);
        evaluationResult.setPercentilesAchieved(this.isPercentilesAchieved(isPercentilesAchievedMap));
        evaluationResult.setSuccessful(this.isSuccessful(evaluationResult));
        evaluationResult.setThroughputQps(this.getThroughputQps());
        return evaluationResult;
    }

    public long getThroughputQps() {
        long configDuration = this.evaluationConfig.getConfigDuration();
        long configWarmUp = this.evaluationConfig.getConfigWarmUp();
        return (long)((float)this.statisticsCalculator.getEvaluationCount() / ((float)configDuration - (float)configWarmUp) * 1000.0f);
    }

    private boolean validateLatency(float actualNs, float requiredMs) {
        long thresholdNs = (long)(requiredMs * (float)TimeUnit.MILLISECONDS.toNanos(1L));
        return actualNs <= (float)thresholdNs;
    }

    public boolean isMinAchieved() {
        if (this.evaluationRequire.getRequireMin() < 0.0f) {
            return true;
        }
        return this.validateLatency(this.statisticsCalculator.getMinLatency(TimeUnit.NANOSECONDS), this.evaluationRequire.getRequireMin());
    }

    public boolean isMaxAchieved() {
        if (this.evaluationRequire.getRequireMax() < 0.0f) {
            return true;
        }
        return this.validateLatency(this.statisticsCalculator.getMaxLatency(TimeUnit.NANOSECONDS), this.evaluationRequire.getRequireMax());
    }

    public boolean isAverageAchieved() {
        if (this.evaluationRequire.getRequireAverage() < 0.0f) {
            return true;
        }
        return this.validateLatency(this.statisticsCalculator.getMeanLatency(TimeUnit.NANOSECONDS), this.evaluationRequire.getRequireAverage());
    }

    public boolean isTimesPerSecondAchieved() {
        return this.evaluationRequire.getRequireTimesPerSecond() < 0 || this.getThroughputQps() >= (long)this.evaluationRequire.getRequireTimesPerSecond();
    }

    private Map<Integer, Boolean> buildIsPercentilesAchievedMap() {
        TreeMap isPercentilesAchievedMap = Maps.newTreeMap();
        for (Map.Entry<Integer, Float> entry : this.evaluationRequire.getRequirePercentilesMap().entrySet()) {
            Integer percentile = entry.getKey();
            float thresholdMs = entry.getValue().floatValue();
            long thresholdNs = (long)(thresholdMs * (float)TimeUnit.MILLISECONDS.toNanos(1L));
            boolean result = this.statisticsCalculator.getLatencyPercentile(percentile, TimeUnit.NANOSECONDS) <= (float)thresholdNs;
            isPercentilesAchievedMap.put(percentile, result);
        }
        return isPercentilesAchievedMap;
    }

    private boolean isPercentilesAchieved(Map<Integer, Boolean> isPercentilesAchievedMap) {
        for (Boolean bool : isPercentilesAchievedMap.values()) {
            if (bool.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean isSuccessful(EvaluationResult evaluationResult) {
        return evaluationResult.isMaxAchieved() && evaluationResult.isMinAchieved() && evaluationResult.isAverageAchieved() && evaluationResult.isTimesPerSecondAchieved() && evaluationResult.isPercentilesAchieved();
    }
}

