/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.junitperf.support.i18n;

import com.github.houbb.junitperf.model.vo.I18nVo;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class I18N {
    private static final String DEFAULT_PROPERTIES_FILE_NAME = "i18n.JunitPerfMessages";

    public static String get(String key) {
        Locale currentLocale = Locale.getDefault();
        ResourceBundle myResources = ResourceBundle.getBundle(DEFAULT_PROPERTIES_FILE_NAME, currentLocale);
        return myResources.getString(key);
    }

    public static I18nVo buildI18nVo() {
        I18nVo vo = new I18nVo();
        vo.setJunit_performance_report(I18N.get("junit_performance_report"));
        vo.setTop(I18N.get("top"));
        vo.setReport_created_by(I18N.get("report_created_by"));
        vo.setWarm_up(I18N.get("warm_up"));
        vo.setStarted_at(I18N.get("started_at"));
        vo.setExecution_time(I18N.get("execution_time"));
        vo.setInvocations(I18N.get("invocations"));
        vo.setThread_count(I18N.get("thread_count"));
        vo.setSuccess(I18N.get("success"));
        vo.setType(I18N.get("type"));
        vo.setActual(I18N.get("actual"));
        vo.setRequired(I18N.get("required"));
        vo.setThroughput(I18N.get("throughput"));
        vo.setMax_latency(I18N.get("max_latency"));
        vo.setMin_latency(I18N.get("min_latency"));
        vo.setAvg_latency(I18N.get("avg_latency"));
        vo.setMemory(I18N.get("memory"));
        return vo;
    }

    public static class Key {
        public static final String memory = "memory";
        public static final String warm_up = "warm_up";
        public static final String max_latency = "max_latency";
        public static final String min_latency = "min_latency";
        public static final String thread_count = "thread_count";
        public static final String report_created_by = "report_created_by";
        public static final String started_at = "started_at";
        public static final String required = "required";
        public static final String junit_performance_report = "junit_performance_report";
        public static final String type = "type";
        public static final String top = "top";
        public static final String throughput = "throughput";
        public static final String avg_latency = "avg_latency";
        public static final String invocations = "invocations";
        public static final String execution_time = "execution_time";
        public static final String success = "success";
        public static final String actual = "actual";
        public static final String reportIsEmpty = "reportIsEmpty";
    }
}

