/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.junitperf.util;

import com.github.houbb.junitperf.support.exception.JunitPerfException;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public final class FreemarkerUtil {
    private static Configuration configuration = null;

    private FreemarkerUtil() {
    }

    public static Configuration getConfiguration(String encoding) {
        return FreemarkerUtil.getConfiguration(encoding, true);
    }

    public static Configuration getConfiguration(String encoding, boolean isForce) {
        if (configuration == null || isForce) {
            configuration = new Configuration();
            configuration.setEncoding(Locale.getDefault(), encoding);
            configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            configuration.setTemplateExceptionHandler(TemplateExceptionHandler.IGNORE_HANDLER);
            configuration.setObjectWrapper((ObjectWrapper)new BeansWrapper());
        }
        return configuration;
    }

    public static boolean createFile(Template template, String targetFilePath, Map<String, Object> map, boolean isOverwriteWhenExists) throws JunitPerfException, IOException {
        boolean result = true;
        File file = new File(targetFilePath);
        boolean makeDirs = file.getParentFile().mkdirs();
        if (!file.exists()) {
            result = file.createNewFile();
            FreemarkerUtil.flushFileContent(template, map, file);
        } else if (file.exists() && isOverwriteWhenExists) {
            FreemarkerUtil.flushFileContent(template, map, file);
        }
        return result;
    }

    private static void flushFileContent(Template template, Map<String, Object> map, File file) throws JunitPerfException {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            template.process(map, (Writer)out);
            ((Writer)out).flush();
        }
        catch (TemplateException | IOException e) {
            throw new JunitPerfException(e);
        }
    }
}

