/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.opencc4j.support.collection;

public final class Char2CharMap {
    private static final char EMPTY_KEY = '\u0000';
    private static final float LOAD_FACTOR = 0.5f;
    private char[] keys;
    private char[] values;
    private int size;
    private int mask;
    private int maxSize;

    public Char2CharMap(int expectedSize) {
        int capacity = Char2CharMap.tableSizeFor((int)((float)expectedSize / 0.5f) + 1);
        this.keys = new char[capacity];
        this.values = new char[capacity];
        this.mask = capacity - 1;
        this.maxSize = (int)((float)capacity * 0.5f);
        this.size = 0;
    }

    private static int tableSizeFor(int cap) {
        int n = cap - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 2 ? 2 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    private int hash(char k) {
        return k * -1640531527 & this.mask;
    }

    public void put(char key, char value) {
        if (key == '\u0000') {
            throw new IllegalArgumentException("Key '\u0000' is reserved as EMPTY_KEY.");
        }
        int idx = this.hash(key);
        while (true) {
            if (this.keys[idx] == '\u0000') {
                this.keys[idx] = key;
                this.values[idx] = value;
                if (++this.size >= this.maxSize) {
                    this.resize();
                }
                return;
            }
            if (this.keys[idx] == key) {
                this.values[idx] = value;
                return;
            }
            idx = idx + 1 & this.mask;
        }
    }

    public char get(char key, char defaultValue) {
        if (key == '\u0000') {
            return defaultValue;
        }
        int idx = this.hash(key);
        char k;
        while ((k = this.keys[idx]) != '\u0000') {
            if (k == key) {
                return this.values[idx];
            }
            idx = idx + 1 & this.mask;
        }
        return defaultValue;
    }

    public char get(char key) {
        char defaultVal = '\u0000';
        return this.get(key, defaultVal);
    }

    private void resize() {
        int newCap = this.keys.length << 1;
        char[] oldKeys = this.keys;
        char[] oldVals = this.values;
        this.keys = new char[newCap];
        this.values = new char[newCap];
        this.mask = newCap - 1;
        this.maxSize = (int)((float)newCap * 0.5f);
        this.size = 0;
        for (int i = 0; i < oldKeys.length; ++i) {
            char k = oldKeys[i];
            if (k == '\u0000') continue;
            this.put(k, oldVals[i]);
        }
    }

    public int size() {
        return this.size;
    }
}

