/*
 * Decompiled with CFR 0.152.
 */
package net.sf.excelutils;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.excelutils.ExcelUtils;
import net.sf.excelutils.WorkbookUtils;
import net.sf.excelutils.tags.ITag;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExcelParser {
    public static final String VALUED_DELIM = "${";
    public static final String VALUED_DELIM2 = "}";
    public static final String KEY_TAG = "#";
    public static Map tagPackageMap = new HashMap();
    private static Map tagMap = new HashMap();

    public static int parse(Object context, Sheet sheet, int fromRow, int toRow) {
        int[] shift = new int[]{0, 0, 0};
        int shiftCount = 0;
        int rownum = fromRow;
        while (rownum <= toRow && (rownum += shift[1] + shift[0]) <= (toRow += shift[1])) {
            shift[0] = 0;
            shift[1] = 0;
            shift[2] = 0;
            Row row = sheet.getRow(rownum);
            ExcelUtils.addValue(context, "currentRowNo", new Integer(rownum + 1));
            if (null == row) {
                ++rownum;
                continue;
            }
            for (short colnum = row.getFirstCellNum(); colnum <= row.getLastCellNum(); colnum = (short)(colnum + 1)) {
                String cellstr;
                Cell cell;
                if (colnum < 0 || null == (cell = row.getCell((int)colnum)) || cell.getCellType() != 1 || null == (cellstr = cell.getStringCellValue()) || "".equals(cellstr)) continue;
                ITag tag = ExcelParser.getTagClass(cellstr);
                if (null != tag) {
                    shift = tag.parseTag(context, sheet, row, cell);
                } else {
                    ExcelParser.parseCell(context, sheet, row, cell);
                }
                shiftCount += shift[1];
                if (shift[2] == 1) break;
            }
            ++rownum;
        }
        return shiftCount;
    }

    public static ITag getTagClass(String str) {
        String tagName = "";
        int keytag = str.indexOf(KEY_TAG);
        if (keytag < 0) {
            return null;
        }
        if (keytag >= str.length() - 1) {
            return null;
        }
        String tagRight = str.substring(keytag + 1, str.length());
        if (tagRight.startsWith(KEY_TAG)) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str = str.substring(str.indexOf(KEY_TAG) + KEY_TAG.length(), str.length()), " ");
        if (st.hasMoreTokens()) {
            tagName = st.nextToken();
        }
        tagName = tagName.substring(0, 1).toUpperCase() + tagName.substring(1, tagName.length());
        ITag tag = (ITag)tagMap.get(tagName = tagName + "Tag");
        if (tag == null) {
            Iterator tagPackages = tagPackageMap.values().iterator();
            while (tagPackages.hasNext() && null == tag) {
                String packageName = (String)tagPackages.next();
                try {
                    Class<?> clazz = Class.forName(packageName + "." + tagName);
                    tag = (ITag)clazz.newInstance();
                }
                catch (Exception e) {
                    tag = null;
                }
            }
            if (tag != null) {
                tagMap.put(tagName, tag);
            }
        }
        return tag;
    }

    public static Object getValue(Object context, String expr) {
        Object value = null;
        try {
            value = PropertyUtils.getProperty((Object)context, (String)expr);
        }
        catch (Exception e) {
            return null;
        }
        return value;
    }

    public static Object parseExpr(Object context, String expr) {
        int indexValued = expr.indexOf(VALUED_DELIM);
        int indexValued2 = expr.lastIndexOf(VALUED_DELIM2);
        Object value = null;
        if (indexValued == 0 && indexValued2 > 0) {
            Object pro;
            String property = expr.substring(indexValued + VALUED_DELIM.length(), indexValued2);
            if (property.startsWith("!")) {
                property = property.substring(1, property.length());
            }
            if (property.indexOf(VALUED_DELIM) >= 0 && null != (pro = ExcelParser.parseStr(context, property))) {
                property = pro.toString();
            }
            value = ExcelParser.getValue(context, property);
        } else if (indexValued > 0 && indexValued2 > 0) {
            value = ExcelParser.parseStr(context, expr);
        }
        return value;
    }

    public static Object parseStr(Object context, String str) {
        return ExcelParser.parseStr(context, str, false);
    }

    public static Object parseStr(Object context, String str, boolean quot) {
        boolean bJustExpr;
        int exprCount = 0;
        int valueFrom = -1;
        int valueTo = -1;
        int valueCount = 0;
        int pos = 0;
        Object value = null;
        int indexValued = str.indexOf(VALUED_DELIM);
        int indexValued2 = str.lastIndexOf(VALUED_DELIM2);
        boolean bl = bJustExpr = str.length() == indexValued2 + VALUED_DELIM2.length() - indexValued;
        while (pos < str.length()) {
            if (pos + VALUED_DELIM.length() <= str.length() && VALUED_DELIM.equals(str.substring(pos, pos + VALUED_DELIM.length()))) {
                if (valueCount == 0) {
                    valueFrom = pos;
                }
                ++valueCount;
                pos += VALUED_DELIM.length();
                continue;
            }
            if (VALUED_DELIM2.equals(str.substring(pos, pos + VALUED_DELIM2.length()))) {
                if (--valueCount == 0) {
                    String rep;
                    valueTo = pos;
                    String expr = str.substring(valueFrom, valueTo + VALUED_DELIM2.length());
                    value = ExcelParser.parseExpr(context, expr);
                    ++exprCount;
                    StringBuffer sbuf = new StringBuffer(str);
                    if (null != value) {
                        rep = value.toString();
                        if (quot) {
                            rep = "\"" + rep + "\"";
                        }
                        sbuf.replace(valueFrom, valueTo + VALUED_DELIM2.length(), rep);
                        pos += VALUED_DELIM2.length() + value.toString().length() - expr.length();
                    } else {
                        rep = "";
                        if (quot) {
                            rep = "\"" + rep + "\"";
                        }
                        sbuf.replace(valueFrom, valueTo + VALUED_DELIM2.length(), rep);
                        pos += VALUED_DELIM2.length() + 0 - expr.length();
                    }
                    str = sbuf.toString();
                    continue;
                }
                pos += VALUED_DELIM2.length();
                continue;
            }
            ++pos;
        }
        if (exprCount == 1 && bJustExpr) {
            if (null != value) {
                if (quot && "java.lang.String".equals(value.getClass().getName())) {
                    return "\"" + value.toString() + "\"";
                }
                return value;
            }
            return value;
        }
        return str;
    }

    public static void parseCell(Object context, Sheet sheet, Row row, Cell cell) {
        String str = cell.getStringCellValue();
        if (null == str || "".equals(str)) {
            return;
        }
        if (str.indexOf(VALUED_DELIM) < 0) {
            return;
        }
        boolean bJustExpr = str.length() == str.length() - str.lastIndexOf(VALUED_DELIM);
        boolean bMerge = "!".equals(str.substring(str.indexOf(VALUED_DELIM) + VALUED_DELIM.length(), str.indexOf(VALUED_DELIM) + VALUED_DELIM.length() + 1));
        if (str.indexOf(VALUED_DELIM) < 0) {
            return;
        }
        Object value = ExcelParser.parseStr(context, str);
        if (null != value) {
            if (bJustExpr && "java.lang.Integer".equals(value.getClass().getName())) {
                cell.setCellValue(Double.parseDouble(value.toString()));
            } else if (bJustExpr && "java.lang.Double".equals(value.getClass().getName())) {
                cell.setCellValue(((Double)value).doubleValue());
            } else if (bJustExpr && "java.util.Date".equals(value.getClass().getName())) {
                cell.setCellValue((Date)value);
            } else if (bJustExpr && "java.lang.Boolean".equals(value.getClass().getName())) {
                cell.setCellValue(((Boolean)value).booleanValue());
            } else {
                cell.setCellValue(value.toString());
            }
        } else {
            cell.setCellValue("");
        }
        if (row.getRowNum() - 1 >= sheet.getFirstRowNum() && bMerge) {
            Row lastRow = WorkbookUtils.getRow(row.getRowNum() - 1, sheet);
            Cell lastCell = WorkbookUtils.getCell(lastRow, cell.getColumnIndex());
            boolean canMerge = false;
            if (lastCell.getCellType() == cell.getCellType()) {
                switch (cell.getCellType()) {
                    case 1: {
                        canMerge = lastCell.getStringCellValue().equals(cell.getStringCellValue());
                        break;
                    }
                    case 4: {
                        canMerge = lastCell.getBooleanCellValue() == cell.getBooleanCellValue();
                        break;
                    }
                    case 0: {
                        boolean bl = canMerge = lastCell.getNumericCellValue() == cell.getNumericCellValue();
                    }
                }
            }
            if (canMerge) {
                sheet.addMergedRegion(new CellRangeAddress(lastRow.getRowNum(), lastCell.getColumnIndex(), row.getRowNum(), cell.getColumnIndex()));
            }
        }
    }

    public static Field[] getBeanProperties(Class clazz) {
        Field[] fields = clazz.getDeclaredFields();
        Method[] methods = clazz.getMethods();
        String m = "";
        for (int i = 0; i < methods.length; ++i) {
            m = m + methods[i].getName() + ",";
        }
        ArrayList<Field> flist = new ArrayList<Field>();
        for (int i = 0; i < fields.length; ++i) {
            if (m.indexOf("get" + fields[i].getName().substring(0, 1).toUpperCase() + fields[i].getName().substring(1, fields[i].getName().length())) < 0) continue;
            flist.add(fields[i]);
        }
        Field[] result = new Field[flist.size()];
        flist.toArray(result);
        return result;
    }

    public static DynaProperty[] getBeanProperties(DynaClass clazz) {
        DynaProperty[] dynaProperties = clazz.getDynaProperties();
        return dynaProperties;
    }

    public static Iterator getIterator(Object collection) {
        Iterator iterator = null;
        if (collection.getClass().isArray()) {
            try {
                iterator = Arrays.asList((Object[])collection).iterator();
            }
            catch (ClassCastException e) {
                int length = Array.getLength(collection);
                ArrayList<Object> c = new ArrayList<Object>(length);
                for (int i = 0; i < length; ++i) {
                    c.add(Array.get(collection, i));
                }
                iterator = c.iterator();
            }
        } else if (collection instanceof Collection) {
            iterator = ((Collection)collection).iterator();
        } else if (collection instanceof Iterator) {
            iterator = (Iterator)collection;
        } else if (collection instanceof Map) {
            iterator = ((Map)collection).entrySet().iterator();
        }
        return iterator;
    }

    public static int getSkipNum(int tagstart, int tagend) {
        return tagend - tagstart;
    }

    public static int getShiftNum(int old_tagend, int tagstart) {
        return tagstart - old_tagend - 1;
    }

    static {
        tagPackageMap.put(ITag.class.getPackage().getName(), ITag.class.getPackage().getName());
    }
}

