/*
 * Decompiled with CFR 0.152.
 */
package net.sf.excelutils;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletContext;
import net.sf.excelutils.ExcelException;
import net.sf.excelutils.ExcelParser;
import net.sf.excelutils.WorkbookUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.LazyDynaBean;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelUtils {
    static ThreadLocal context = new ThreadLocal();

    public static void export(ServletContext ctx, String config, Object context, OutputStream out) throws ExcelException {
        try {
            Workbook wb = WorkbookUtils.openWorkbook(ctx, config);
            ExcelUtils.parseWorkbook(context, wb);
            wb.write(out);
        }
        catch (Exception e) {
            throw new ExcelException(e.getMessage());
        }
    }

    public static void export(ServletContext ctx, String config, int sheetIndex, Object context, OutputStream out) throws ExcelException {
        try {
            Workbook wb = WorkbookUtils.openWorkbook(ctx, config);
            ExcelUtils.parseWorkbook(context, wb, sheetIndex);
            wb.write(out);
        }
        catch (Exception e) {
            throw new ExcelException(e.getMessage());
        }
    }

    public static void export(ServletContext ctx, String config, OutputStream out) throws ExcelException {
        try {
            ExcelUtils.export(ctx, config, (Object)ExcelUtils.getContext(), out);
        }
        catch (Exception e) {
            throw new ExcelException(e.getMessage());
        }
    }

    public static void export(ServletContext ctx, String config, int sheetIndex, OutputStream out) throws ExcelException {
        try {
            ExcelUtils.export(ctx, config, sheetIndex, ExcelUtils.getContext(), out);
        }
        catch (Exception e) {
            throw new ExcelException(e.getMessage());
        }
    }

    public static void export(String fileName, Object context, OutputStream out) throws ExcelException {
        try {
            Workbook wb = WorkbookUtils.openWorkbook(fileName);
            ExcelUtils.parseWorkbook(context, wb);
            wb.write(out);
        }
        catch (Exception e) {
            throw new ExcelException(e.getMessage());
        }
    }

    public static void export(String fileName, int sheetIndex, Object context, OutputStream out) throws ExcelException {
        try {
            Workbook wb = WorkbookUtils.openWorkbook(fileName);
            ExcelUtils.parseWorkbook(context, wb, sheetIndex);
            wb.write(out);
        }
        catch (Exception e) {
            throw new ExcelException(e.getMessage());
        }
    }

    public static void export(String fileName, OutputStream out) throws ExcelException {
        try {
            ExcelUtils.export(fileName, (Object)ExcelUtils.getContext(), out);
        }
        catch (Exception e) {
            throw new ExcelException(e.getMessage());
        }
    }

    public static void export(String fileName, int sheetIndex, OutputStream out) throws ExcelException {
        try {
            ExcelUtils.export(fileName, sheetIndex, (Object)ExcelUtils.getContext(), out);
        }
        catch (Exception e) {
            throw new ExcelException(e.getMessage());
        }
    }

    public static void export(InputStream inputStream, Object context, OutputStream out) throws ExcelException {
        try {
            Workbook wb = WorkbookUtils.openWorkbook(inputStream);
            ExcelUtils.parseWorkbook(context, wb);
            wb.write(out);
        }
        catch (Exception e) {
            throw new ExcelException(e.getMessage());
        }
    }

    public static void parseWorkbook(Object context, Workbook wb) throws ExcelException {
        try {
            int sheetCount = wb.getNumberOfSheets();
            for (int sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
                Sheet sheet = wb.getSheetAt(sheetIndex);
                ExcelUtils.parseSheet(context, sheet);
            }
        }
        catch (Exception e) {
            throw new ExcelException(e.getMessage());
        }
    }

    public static void parseWorkbook(Object context, Workbook wb, int sheetIndex) throws ExcelException {
        try {
            Sheet sheet = wb.getSheetAt(sheetIndex);
            if (null != sheet) {
                ExcelUtils.parseSheet(context, sheet);
            }
            int i = 0;
            while (i++ < sheetIndex) {
                wb.removeSheetAt(0);
            }
            i = 1;
            while (i < wb.getNumberOfSheets()) {
                wb.removeSheetAt(i);
            }
        }
        catch (Exception e) {
            throw new ExcelException(e.getMessage());
        }
    }

    public static void parseSheet(Object context, Sheet sheet) throws ExcelException {
        try {
            ExcelParser.parse(context, sheet, sheet.getFirstRowNum(), sheet.getLastRowNum());
        }
        catch (Exception e) {
            throw new ExcelException(e.getMessage());
        }
        finally {
            ExcelUtils.context.set(null);
        }
    }

    public static void addService(Object context, String key, Object service) {
        ExcelUtils.addValue(context, key, service);
    }

    public static void addService(String key, Object service) {
        ExcelUtils.addValue(key, service);
    }

    public static void addValue(Object context, String key, Object value) {
        if (context instanceof DynaBean) {
            ((DynaBean)context).set(key, value);
        } else if (context instanceof Map) {
            ((Map)context).put(key, value);
        }
    }

    public static void addValue(String key, Object value) {
        ExcelUtils.getContext().set(key, value);
    }

    public static synchronized void registerTagPackage(String packageName) {
        ExcelParser.tagPackageMap.put(packageName, packageName);
    }

    public static DynaBean getContext() {
        DynaBean ctx = (DynaBean)context.get();
        if (null == ctx) {
            ctx = new LazyDynaBean();
            ExcelUtils.setContext(ctx);
        }
        return ctx;
    }

    public static void setContext(DynaBean ctx) {
        context.set(ctx);
    }

    public static boolean isCanShowType(Object value) {
        if (null == value) {
            return false;
        }
        String valueType = value.getClass().getName();
        return "java.lang.String".equals(valueType) || "java.lang.Double".equals(valueType) || "java.lang.Integer".equals(valueType) || "java.lang.Boolean".equals(valueType) || "java.sql.Timestamp".equals(valueType) || "java.util.Date".equals(valueType) || "java.lang.Byte".equals(valueType) || "java.math.BigDecimal".equals(valueType) || "java.math.BigInteger".equals(valueType) || "java.lang.Float".equals(valueType) || value.getClass().isPrimitive();
    }
}

