/*
 * Decompiled with CFR 0.152.
 */
package net.sf.excelutils;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.ServletContext;
import net.sf.excelutils.ExcelException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;

public class WorkbookUtils {
    public static Workbook openWorkbook(ServletContext ctx, String config) throws ExcelException {
        InputStream in = null;
        Workbook wb = null;
        try {
            in = ctx.getResourceAsStream(config);
            wb = WorkbookFactory.create((InputStream)in);
        }
        catch (Exception e) {
            throw new ExcelException("File" + config + "not found," + e.getMessage());
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
        return wb;
    }

    public static Workbook openWorkbook(String fileName) throws ExcelException {
        FileInputStream in = null;
        Workbook wb = null;
        try {
            in = new FileInputStream(fileName);
            wb = WorkbookFactory.create((InputStream)in);
        }
        catch (Exception e) {
            throw new ExcelException("File" + fileName + "not found" + e.getMessage());
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (Exception e) {}
        }
        return wb;
    }

    public static Workbook openWorkbook(InputStream in) throws ExcelException {
        Workbook wb = null;
        try {
            wb = WorkbookFactory.create((InputStream)in);
        }
        catch (Exception e) {
            throw new ExcelException(e.getMessage());
        }
        return wb;
    }

    public static void SaveWorkbook(Workbook wb, OutputStream out) throws ExcelException {
        try {
            wb.write(out);
        }
        catch (Exception e) {
            throw new ExcelException(e.getMessage());
        }
    }

    public static void setCellValue(Sheet sheet, int rowNum, int colNum, String value) {
        Row row = WorkbookUtils.getRow(rowNum, sheet);
        Cell cell = WorkbookUtils.getCell(row, colNum);
        cell.setCellValue(value);
    }

    public static String getStringCellValue(Sheet sheet, int rowNum, int colNum) {
        Row row = WorkbookUtils.getRow(rowNum, sheet);
        Cell cell = WorkbookUtils.getCell(row, colNum);
        return cell.getStringCellValue();
    }

    public static void setCellValue(Sheet sheet, int rowNum, int colNum, String value, short encoding) {
        Row row = WorkbookUtils.getRow(rowNum, sheet);
        Cell cell = WorkbookUtils.getCell(row, colNum);
        cell.setCellValue(value);
    }

    public static void setCellValue(Sheet sheet, int rowNum, int colNum, double value) {
        Row row = WorkbookUtils.getRow(rowNum, sheet);
        Cell cell = WorkbookUtils.getCell(row, colNum);
        cell.setCellValue(value);
    }

    public static double getNumericCellValue(Sheet sheet, int rowNum, int colNum) {
        Row row = WorkbookUtils.getRow(rowNum, sheet);
        Cell cell = WorkbookUtils.getCell(row, colNum);
        return cell.getNumericCellValue();
    }

    public static void setCellValue(Sheet sheet, int rowNum, int colNum, Date value) {
        Row row = WorkbookUtils.getRow(rowNum, sheet);
        Cell cell = WorkbookUtils.getCell(row, colNum);
        cell.setCellValue(value);
    }

    public static Date getDateCellValue(Sheet sheet, int rowNum, int colNum) {
        Row row = WorkbookUtils.getRow(rowNum, sheet);
        Cell cell = WorkbookUtils.getCell(row, colNum);
        return cell.getDateCellValue();
    }

    public static void setCellValue(Sheet sheet, int rowNum, int colNum, boolean value) {
        Row row = WorkbookUtils.getRow(rowNum, sheet);
        Cell cell = WorkbookUtils.getCell(row, colNum);
        cell.setCellValue(value);
    }

    public static boolean getBooleanCellValue(Sheet sheet, int rowNum, int colNum) {
        Row row = WorkbookUtils.getRow(rowNum, sheet);
        Cell cell = WorkbookUtils.getCell(row, colNum);
        return cell.getBooleanCellValue();
    }

    public static Row getRow(int rowCounter, Sheet sheet) {
        Row row = sheet.getRow((int)((short)rowCounter));
        if (row == null) {
            row = sheet.createRow((int)((short)rowCounter));
        }
        return row;
    }

    public static Cell getCell(Row row, int column) {
        Cell cell = row.getCell((int)((short)column));
        if (cell == null) {
            cell = row.createCell((int)((short)column));
        }
        return cell;
    }

    public static Cell getCell(Sheet sheet, int rowNum, int colNum) {
        Row row = WorkbookUtils.getRow(rowNum, sheet);
        Cell cell = WorkbookUtils.getCell(row, colNum);
        return cell;
    }

    public static void copyRow(Sheet sheet, int from, int to, int count) {
        for (int rownum = from; rownum < from + count; ++rownum) {
            Row fromRow = sheet.getRow(rownum);
            Row toRow = WorkbookUtils.getRow(to + rownum - from, sheet);
            if (null == fromRow) {
                return;
            }
            toRow.setHeight(fromRow.getHeight());
            toRow.setHeightInPoints(fromRow.getHeightInPoints());
            short limit = fromRow.getLastCellNum();
            block7: for (int i = fromRow.getFirstCellNum(); i <= limit && i >= 0; ++i) {
                Cell fromCell = WorkbookUtils.getCell(fromRow, i);
                Cell toCell = WorkbookUtils.getCell(toRow, i);
                toCell.setCellStyle(fromCell.getCellStyle());
                toCell.setCellType(fromCell.getCellType());
                switch (fromCell.getCellType()) {
                    case 4: {
                        toCell.setCellValue(fromCell.getBooleanCellValue());
                        continue block7;
                    }
                    case 2: {
                        toCell.setCellFormula(fromCell.getCellFormula());
                        continue block7;
                    }
                    case 0: {
                        toCell.setCellValue(fromCell.getNumericCellValue());
                        continue block7;
                    }
                    case 1: {
                        toCell.setCellValue(fromCell.getStringCellValue());
                        continue block7;
                    }
                }
            }
        }
        ArrayList<CellRangeAddress> shiftedRegions = new ArrayList<CellRangeAddress>();
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            CellRangeAddress r = sheet.getMergedRegion(i);
            if (r.getFirstRow() < from || r.getLastRow() >= from + count) continue;
            CellRangeAddress n_r = new CellRangeAddress(r.getFirstRow() + to - from, r.getLastRow() + to - from, r.getFirstColumn(), r.getLastColumn());
            shiftedRegions.add(n_r);
        }
        for (CellRangeAddress region : shiftedRegions) {
            sheet.addMergedRegion(region);
        }
    }

    public static void shiftCell(Sheet sheet, Row row, Cell beginCell, int shift, int rowCount) {
        if (shift == 0) {
            return;
        }
        int fromRow = row.getRowNum();
        int toRow = row.getRowNum() + rowCount - 1;
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            CellRangeAddress r = sheet.getMergedRegion(i);
            if (r.getFirstRow() != row.getRowNum()) continue;
            if (r.getLastRow() > toRow) {
                toRow = r.getLastRow();
            }
            if (r.getFirstRow() >= fromRow) continue;
            fromRow = r.getFirstRow();
        }
        for (int rownum = fromRow; rownum <= toRow; ++rownum) {
            Cell fromCell;
            int lastCellNum;
            int cellpos;
            Row curRow = WorkbookUtils.getRow(rownum, sheet);
            for (cellpos = lastCellNum = curRow.getLastCellNum(); cellpos >= beginCell.getColumnIndex(); --cellpos) {
                fromCell = WorkbookUtils.getCell(curRow, cellpos);
                Cell toCell = WorkbookUtils.getCell(curRow, cellpos + shift);
                toCell.setCellType(fromCell.getCellType());
                toCell.setCellStyle(fromCell.getCellStyle());
                switch (fromCell.getCellType()) {
                    case 4: {
                        toCell.setCellValue(fromCell.getBooleanCellValue());
                        break;
                    }
                    case 2: {
                        toCell.setCellFormula(fromCell.getCellFormula());
                        break;
                    }
                    case 0: {
                        toCell.setCellValue(fromCell.getNumericCellValue());
                        break;
                    }
                    case 1: {
                        toCell.setCellValue(fromCell.getStringCellValue());
                        break;
                    }
                    case 5: {
                        toCell.setCellErrorValue(fromCell.getErrorCellValue());
                    }
                }
                fromCell.setCellValue("");
                fromCell.setCellType(3);
                Workbook wb = sheet.getWorkbook();
                CellStyle style = wb.createCellStyle();
                fromCell.setCellStyle(style);
            }
            for (cellpos = lastCellNum; cellpos >= beginCell.getColumnIndex(); --cellpos) {
                fromCell = WorkbookUtils.getCell(curRow, cellpos);
                ArrayList<CellRangeAddress> shiftedRegions = new ArrayList<CellRangeAddress>();
                for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
                    CellRangeAddress r = sheet.getMergedRegion(i);
                    if (r.getFirstRow() != curRow.getRowNum() || r.getFirstColumn() != fromCell.getColumnIndex()) continue;
                    r.setFirstColumn((int)((short)(r.getFirstColumn() + shift)));
                    r.setLastColumn((int)((short)(r.getLastColumn() + shift)));
                    shiftedRegions.add(r);
                    sheet.removeMergedRegion(i);
                    --i;
                }
                for (CellRangeAddress region : shiftedRegions) {
                    sheet.addMergedRegion(region);
                }
            }
        }
    }
}

