/*
 * Decompiled with CFR 0.152.
 */
package net.sf.excelutils.tags;

import java.lang.reflect.Method;
import java.util.StringTokenizer;
import net.sf.excelutils.ExcelParser;
import net.sf.excelutils.ExcelUtils;
import net.sf.excelutils.tags.ITag;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class CallTag
implements ITag {
    public static final String KEY_CALL = "#call";

    public int[] parseTag(Object context, Sheet sheet, Row curRow, Cell curCell) {
        Object service;
        String cellstr = curCell.getStringCellValue();
        if (null == cellstr || "".equals(cellstr)) {
            return new int[]{0, 0, 0};
        }
        cellstr = cellstr.substring(KEY_CALL.length()).trim();
        String serviceName = cellstr.substring(0, cellstr.indexOf(46));
        String methodName = cellstr.substring(cellstr.indexOf(46) + 1, cellstr.indexOf(40));
        String paramStr = cellstr.substring(cellstr.indexOf(40) + 1, cellstr.lastIndexOf(41));
        String propertyName = cellstr.substring(cellstr.lastIndexOf(41) + 1);
        Object[] params = new Object[]{};
        Class[] types = new Class[]{};
        if (!"".equals(paramStr) && null != paramStr) {
            StringTokenizer st = new StringTokenizer(paramStr, ",");
            params = new Object[st.countTokens()];
            types = new Class[st.countTokens()];
            int index = 0;
            while (st.hasMoreTokens()) {
                String param = st.nextToken().trim();
                types[index] = this.getParamType(param);
                if ("java.lang.Object".equals(types[index].getName())) {
                    params[index] = ExcelParser.parseStr(context, param);
                    types[index] = params[index].getClass();
                } else if ("boolean".equals(types[index].getName())) {
                    params[index] = Boolean.valueOf(param);
                } else if ("int".equals(types[index].getName())) {
                    params[index] = Integer.valueOf(param);
                } else if ("double".equals(types[index].getName())) {
                    params[index] = Double.valueOf(param);
                } else if ("java.lang.String".equals(types[index].getName())) {
                    params[index] = param.substring(1, param.length() - 1);
                }
                ++index;
            }
        }
        if (null == (service = ExcelParser.getValue(context, serviceName))) {
            return new int[]{0, 0, 0};
        }
        Method method = this.findMethod(service, methodName, types);
        if (null == method) {
            return new int[]{0, 0, 0};
        }
        try {
            Object result = method.invoke(service, params);
            ExcelUtils.addValue(context, serviceName + methodName, result);
            curCell.setCellValue("${" + serviceName + methodName + propertyName + "}");
            ExcelParser.parseCell(context, sheet, curRow, curCell);
        }
        catch (Exception e) {
            // empty catch block
        }
        return new int[]{0, 0, 0};
    }

    public boolean hasEndTag() {
        return false;
    }

    public String getTagName() {
        return KEY_CALL;
    }

    private Method findMethod(Object service, String methodName, Class[] types) {
        Class<?> clazz = service instanceof Class ? (Class<?>)service : service.getClass();
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(methodName, types);
        }
        catch (Exception e) {
            // empty catch block
        }
        return method;
    }

    private Class getParamType(String param) {
        if (param.startsWith("\"") && param.endsWith("\"")) {
            return String.class;
        }
        if (param.indexOf("${") >= 0) {
            return Object.class;
        }
        if (param.equals("true") || param.equals("false")) {
            return Boolean.TYPE;
        }
        if (param.indexOf(46) >= 0) {
            return Double.TYPE;
        }
        return Integer.TYPE;
    }
}

