/*
 * Decompiled with CFR 0.152.
 */
package net.sf.excelutils.tags;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.excelutils.ExcelParser;
import net.sf.excelutils.ExcelUtils;
import net.sf.excelutils.WorkbookUtils;
import net.sf.excelutils.tags.ITag;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class EachTag
implements ITag {
    public static final String KEY_EACH = "#each";

    public int[] parseTag(Object context, Sheet sheet, Row curRow, Cell curCell) {
        Object obj;
        Object o;
        String expr = "";
        String each = curCell.getStringCellValue();
        StringTokenizer st = new StringTokenizer(each, " ");
        String widthstr = "";
        String onstr = "";
        int pos = 0;
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            if (pos == 1) {
                expr = str;
            }
            if (pos == 2 && !"on".equals(str)) {
                widthstr = str;
            }
            if (pos == 3 && !"on".equals(str)) {
                onstr = str;
            }
            if (pos == 4) {
                onstr = str;
            }
            ++pos;
        }
        int[] widths = new int[]{};
        if (null != widthstr && !"".equals(widthstr) && null != (o = ExcelParser.parseStr(context, widthstr))) {
            String[] s = o.toString().split(",");
            widths = new int[s.length];
            for (int i = 0; i < widths.length; ++i) {
                widths[i] = Integer.parseInt(s[i]);
            }
        }
        if (null == (obj = ExcelParser.parseExpr(context, expr))) {
            return new int[]{0, 0, 0};
        }
        if (!"".equals(onstr) && null == (obj = ExcelParser.parseExpr(context, onstr))) {
            return new int[]{0, 0, 0};
        }
        Iterator it = ExcelParser.getIterator(obj);
        if (null == it) {
            it = obj instanceof DynaBean ? ExcelParser.getIterator(ExcelParser.getBeanProperties(((DynaBean)obj).getDynaClass())) : ExcelParser.getIterator(ExcelParser.getBeanProperties(obj.getClass()));
        }
        if (null == it) {
            return new int[]{0, 0, 0};
        }
        int index = 0;
        int arrayIndex = 0;
        int eachPos = curCell.getColumnIndex();
        String modelName = expr.substring("${".length(), expr.length() - "}".length());
        obj = ExcelParser.parseExpr(context, expr);
        while (it.hasNext()) {
            Object o2 = it.next();
            String property = "";
            property = o2 instanceof Field ? ((Field)o2).getName() : (o2 instanceof Map.Entry ? ((Map.Entry)o2).getKey().toString() : (o2 instanceof DynaProperty ? ((DynaProperty)o2).getName() : o2.toString()));
            property = obj.getClass().isArray() || obj instanceof Collection ? modelName + "[" + arrayIndex++ + "]" : modelName + "." + property;
            Object value = ExcelParser.getValue(context, property);
            if (null == value) {
                value = "";
            }
            if (!ExcelUtils.isCanShowType(value)) continue;
            int width = 1;
            if (index < widths.length) {
                width = widths[index];
            } else if (1 == widths.length) {
                width = widths[0];
            }
            int rowMerged = 1;
            for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
                CellRangeAddress r = sheet.getMergedRegion(i);
                if (r.getFirstRow() != curRow.getRowNum() || r.getFirstColumn() != curCell.getColumnIndex() || r.getLastColumn() != curCell.getColumnIndex()) continue;
                rowMerged = r.getLastRow() - r.getFirstRow() + 1;
                break;
            }
            Cell cell = WorkbookUtils.getCell(curRow, eachPos);
            if (index > 0) {
                WorkbookUtils.shiftCell(sheet, curRow, cell, 1, rowMerged);
            }
            if (width > 1) {
                Cell nextCell = WorkbookUtils.getCell(curRow, eachPos + 1);
                WorkbookUtils.shiftCell(sheet, curRow, nextCell, width - 1, rowMerged);
            }
            for (int rownum = curRow.getRowNum(); rownum < curRow.getRowNum() + rowMerged; ++rownum) {
                for (int i = 0; i < width; ++i) {
                    Row r = WorkbookUtils.getRow(rownum, sheet);
                    Cell c = WorkbookUtils.getCell(r, eachPos + i);
                    Cell cc = WorkbookUtils.getCell(r, curCell.getColumnIndex());
                    c.setCellStyle(cc.getCellStyle());
                }
            }
            if (width > 1 || rowMerged > 1) {
                sheet.addMergedRegion(new CellRangeAddress(curRow.getRowNum(), cell.getColumnIndex(), curRow.getRowNum() + rowMerged - 1, (int)((short)(cell.getColumnIndex() + width - 1))));
            }
            cell.setCellValue("${" + property + "}");
            ExcelParser.parseCell(context, sheet, curRow, cell);
            eachPos += width;
            ++index;
        }
        return new int[]{0, 0, 0};
    }

    public String getTagName() {
        return KEY_EACH;
    }

    public boolean hasEndTag() {
        return false;
    }
}

