/*
 * Decompiled with CFR 0.152.
 */
package net.sf.excelutils.tags;

import java.util.Iterator;
import java.util.StringTokenizer;
import net.sf.excelutils.ExcelParser;
import net.sf.excelutils.ExcelUtils;
import net.sf.excelutils.WorkbookUtils;
import net.sf.excelutils.tags.ITag;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class ForeachTag
implements ITag {
    public static final String KEY_FOREACH = "#foreach";
    public static final String KEY_END = "#end";

    public int[] parseTag(Object context, Sheet sheet, Row curRow, Cell curCell) {
        int forstart = curRow.getRowNum();
        int forend = -1;
        int forCount = 0;
        String foreach = "";
        boolean bFind = false;
        for (int rownum = forstart; rownum <= sheet.getLastRowNum(); ++rownum) {
            Row row;
            if (rownum < 0 || null == (row = sheet.getRow(rownum))) continue;
            for (short colnum = row.getFirstCellNum(); colnum <= row.getLastCellNum(); colnum = (short)(colnum + 1)) {
                Cell cell;
                if (colnum < 0 || null == (cell = row.getCell((int)colnum)) || cell.getCellType() != 1) continue;
                String cellstr = cell.getStringCellValue();
                ITag tag = ExcelParser.getTagClass(cellstr);
                if (null != tag && tag.hasEndTag()) {
                    if (0 == forCount) {
                        forstart = rownum;
                        foreach = cellstr;
                    }
                    ++forCount;
                    break;
                }
                if (!cellstr.startsWith(KEY_END)) continue;
                forend = rownum;
                if (forstart < 0 || forend < 0 || forend <= forstart || --forCount != 0) break;
                bFind = true;
                break;
            }
            if (bFind) break;
        }
        if (!bFind) {
            return new int[]{0, 0, 1};
        }
        String properties = "";
        String property = "";
        StringTokenizer st = new StringTokenizer(foreach, " ");
        int pos = 0;
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            if (pos == 1) {
                property = str;
            }
            if (pos == 3) {
                properties = str;
            }
            ++pos;
        }
        Object collection = ExcelParser.parseStr(context, properties);
        if (null == collection) {
            return new int[]{0, 0, 1};
        }
        Iterator iterator = ExcelParser.getIterator(collection);
        int shiftNum = forend - forstart - 1;
        ExcelUtils.addValue(context, property + "StartRowNo", new Integer(forstart + 1));
        int old_forend = forend;
        int propertyId = 0;
        int shift = 0;
        if (null != iterator) {
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                ExcelUtils.addValue(context, property, obj);
                ExcelUtils.addValue(context, property + "Id", new Integer(propertyId));
                ExcelUtils.addValue(context, property + "Index", new Integer(propertyId + 1));
                sheet.shiftRows(forstart, sheet.getLastRowNum(), shiftNum, true, true);
                WorkbookUtils.copyRow(sheet, forstart + shiftNum + 1, forstart, shiftNum);
                shift = ExcelParser.parse(context, sheet, forstart, forstart + shiftNum - 1);
                forstart += shiftNum + shift;
                forend += shiftNum + shift;
                ++propertyId;
            }
        }
        ExcelUtils.addValue(context, property + "EndRowNo", new Integer(forstart));
        for (int rownum = forstart; rownum <= forend; ++rownum) {
            sheet.removeRow(WorkbookUtils.getRow(rownum, sheet));
        }
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            CellRangeAddress r = sheet.getMergedRegion(i);
            if (r.getFirstRow() < forstart || r.getLastRow() > forend) continue;
            sheet.removeMergedRegion(i);
            --i;
        }
        int startRow = forend + 1;
        int endRow = sheet.getLastRowNum();
        if (startRow < endRow) {
            sheet.shiftRows(forend + 1, sheet.getLastRowNum(), -(forend - forstart + 1), true, true);
        }
        return new int[]{ExcelParser.getSkipNum(forstart, forend), ExcelParser.getShiftNum(old_forend, forstart), 1};
    }

    public String getTagName() {
        return KEY_FOREACH;
    }

    public boolean hasEndTag() {
        return true;
    }
}

