/*
 * Decompiled with CFR 0.152.
 */
package net.sf.excelutils.tags;

import bsh.EvalError;
import bsh.Interpreter;
import net.sf.excelutils.ExcelParser;
import net.sf.excelutils.WorkbookUtils;
import net.sf.excelutils.tags.ITag;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class IfTag
implements ITag {
    public static final String KEY_IF = "#if";
    public static final String KEY_END = "#end";

    public int[] parseTag(Object context, Sheet sheet, Row curRow, Cell curCell) {
        CellRangeAddress r;
        int ifstart = curRow.getRowNum();
        int ifend = -1;
        int ifCount = 0;
        String ifstr = "";
        boolean bFind = false;
        for (int rownum = ifstart; rownum <= sheet.getLastRowNum(); ++rownum) {
            Row row = sheet.getRow(rownum);
            if (null == row) continue;
            for (short colnum = row.getFirstCellNum(); colnum <= row.getLastCellNum(); colnum = (short)(colnum + 1)) {
                Cell cell = row.getCell((int)colnum);
                if (null == cell || cell.getCellType() != 1) continue;
                String cellstr = cell.getStringCellValue();
                ITag tag = ExcelParser.getTagClass(cellstr);
                if (null != tag && tag.hasEndTag()) {
                    if (0 == ifCount) {
                        ifstart = rownum;
                        ifstr = cellstr;
                    }
                    ++ifCount;
                    break;
                }
                if (!cellstr.startsWith(KEY_END)) continue;
                ifend = rownum;
                if (ifstart < 0 || ifend < 0 || ifend <= ifstart || --ifCount != 0) break;
                bFind = true;
                break;
            }
            if (bFind) break;
        }
        if (!bFind) {
            return new int[]{0, 0, 1};
        }
        boolean bResult = false;
        String expr = ifstr.trim().substring(KEY_IF.length()).trim();
        expr = (String)ExcelParser.parseStr(context, expr, true);
        Interpreter in = new Interpreter();
        try {
            Object v = in.eval(expr);
            bResult = (Boolean)v;
        }
        catch (Exception e) {
            bResult = false;
        }
        if (bResult) {
            sheet.removeRow(WorkbookUtils.getRow(ifstart, sheet));
            sheet.removeRow(WorkbookUtils.getRow(ifend, sheet));
            for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
                r = sheet.getMergedRegion(i);
                if ((r.getFirstRow() != ifstart || r.getLastRow() != ifstart) && (r.getFirstRow() != ifend || r.getLastRow() != ifend)) continue;
                sheet.removeMergedRegion(i);
                --i;
            }
            sheet.shiftRows(ifend + 1, sheet.getLastRowNum(), -1, true, true);
            sheet.shiftRows(ifstart + 1, sheet.getLastRowNum(), -1, true, true);
            return new int[]{1, -2, 1};
        }
        for (int rownum = ifstart; rownum <= ifend; ++rownum) {
            sheet.removeRow(WorkbookUtils.getRow(rownum, sheet));
        }
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            r = sheet.getMergedRegion(i);
            if (r.getFirstRow() < ifstart || r.getLastRow() > ifend) continue;
            sheet.removeMergedRegion(i);
            --i;
        }
        sheet.shiftRows(ifend + 1, sheet.getLastRowNum(), -(ifend - ifstart + 1), true, true);
        return new int[]{ExcelParser.getSkipNum(ifstart, ifend), ExcelParser.getShiftNum(ifend, ifstart), 1};
    }

    public String getTagName() {
        return KEY_IF;
    }

    public boolean hasEndTag() {
        return true;
    }

    public static void main(String[] args) {
        Interpreter in = new Interpreter();
        try {
            in.set("a", (Object)"5a");
            in.set("b", (Object)"5a");
            in.eval("bar=\"5a\"==\"5a\"");
            System.out.println(in.get("bar"));
        }
        catch (EvalError e) {
            e.printStackTrace();
        }
    }
}

