/*
 * Decompiled with CFR 0.152.
 */
package net.sf.excelutils.tags;

import java.util.Iterator;
import java.util.StringTokenizer;
import net.sf.excelutils.ExcelParser;
import net.sf.excelutils.tags.ITag;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class SumTag
implements ITag {
    public static final String KEY_SUM = "#sum";

    public int[] parseTag(Object context, Sheet sheet, Row curRow, Cell curCell) {
        String cellstr = curCell.getStringCellValue();
        if (null == cellstr || "".equals(cellstr)) {
            return new int[]{0, 0, 0};
        }
        String property = "";
        String collectionName = "";
        String whereName = "";
        String whereStr = "";
        boolean bEquals = true;
        String hasStr = cellstr.substring(0, cellstr.indexOf(this.getTagName()));
        cellstr = cellstr.substring(cellstr.indexOf(this.getTagName()), cellstr.length());
        cellstr = cellstr.replaceAll("=", " = ");
        StringTokenizer st = new StringTokenizer(cellstr, " ");
        int pos = 0;
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            if (pos == 1) {
                property = str;
            }
            if (pos == 3) {
                collectionName = str;
            }
            if (pos == 5) {
                whereName = str;
            }
            if (pos == 6) {
                bEquals = "=".equals(str.trim());
            }
            if (pos == 7) {
                whereStr = str;
            }
            ++pos;
        }
        double sum = 0.0;
        if (!"".equals(collectionName) && !"".equals(property)) {
            Object collection = ExcelParser.parseStr(context, collectionName);
            if (null == collection) {
                return new int[]{0, 0, 0};
            }
            Iterator iterator = ExcelParser.getIterator(collection);
            while (iterator.hasNext()) {
                Object value;
                Object model = iterator.next();
                if (null == model || null == (value = ExcelParser.getValue(model, property))) continue;
                if (!"".equals(whereName) && !"".equals(whereStr)) {
                    Object where = ExcelParser.getValue(model, whereName);
                    Object whereValue = null;
                    if (whereStr.startsWith("${")) {
                        whereValue = ExcelParser.parseStr(context, whereStr);
                    }
                    if (null == whereValue) {
                        whereValue = whereStr;
                    }
                    if (null != where && (!bEquals ? where.toString().indexOf(whereValue.toString()) < 0 : !where.toString().equals(whereValue.toString()))) continue;
                }
                if (!"java.lang.Integer".equals(value.getClass().getName()) && !"java.lang.Double".equals(value.getClass().getName())) continue;
                sum += Double.parseDouble(value.toString());
            }
        }
        if (!"".equals(hasStr)) {
            curCell.setCellValue(hasStr + sum);
        } else {
            curCell.setCellValue(sum);
        }
        return new int[]{0, 0, 0};
    }

    public String getTagName() {
        return KEY_SUM;
    }

    public boolean hasEndTag() {
        return false;
    }
}

