/*
 * Decompiled with CFR 0.152.
 */
package net.sf.excelutils.webwork;

import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.InputStream;
import javax.servlet.ServletContext;
import net.sf.excelutils.ExcelUtils;
import net.sf.excelutils.webwork.ExcelLoader;
import net.sf.excelutils.webwork.MutiExcelLoader;
import net.sf.excelutils.webwork.OgnlDynaBean;
import net.sf.excelutils.webwork.WebappExcelLoader;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExcelManager {
    private static final Log log = LogFactory.getLog(ExcelManager.class);
    private static ExcelManager instance = null;
    protected ExcelLoader excelLoader = null;

    public static final synchronized ExcelManager getInstance() {
        if (instance == null) {
            String classname = ExcelManager.class.getName();
            if (Configuration.isSet((String)"webwork.excel.manager.classname")) {
                classname = Configuration.getString((String)"webwork.excel.manager.classname").trim();
            }
            try {
                log.info((Object)("Instantiating Excel ConfigManager!, " + classname));
                instance = (ExcelManager)ObjectFactory.getObjectFactory().buildBean(Class.forName(classname));
            }
            catch (Exception e) {
                log.fatal((Object)("Fatal exception occurred while trying to instantiate a Excel ConfigManager instance, " + classname), (Throwable)e);
            }
        }
        if (instance == null) {
            instance = new ExcelManager();
        }
        return instance;
    }

    public Object buildContextObject(OgnlValueStack stack) {
        OgnlDynaBean context = new OgnlDynaBean(stack);
        try {
            DynaProperty[] properties = ExcelUtils.getContext().getDynaClass().getDynaProperties();
            for (int i = 0; i < properties.length; ++i) {
                Object value = ExcelUtils.getContext().get(properties[i].getName());
                if (null == value) continue;
                context.set(properties[i].getName(), value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return context;
    }

    protected ExcelLoader getExcelLoader(ServletContext context) {
        if (this.excelLoader == null) {
            this.excelLoader = new MutiExcelLoader(new ExcelLoader[]{new WebappExcelLoader(context)});
        }
        return this.excelLoader;
    }

    public InputStream getExcel(ServletContext context, String location) {
        return this.getExcelLoader(context).getExcel(location);
    }
}

