/*
 * Decompiled with CFR 0.152.
 */
package net.sf.excelutils.webwork;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.dispatcher.WebWorkResultSupport;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sf.excelutils.ExcelUtils;
import net.sf.excelutils.webwork.ExcelManager;

public class ExcelResult
extends WebWorkResultSupport {
    private static final long serialVersionUID = 1L;
    protected String contentType = "application/vnd.ms-excel";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(String location, ActionInvocation invocation) throws Exception {
        HttpServletResponse response = ServletActionContext.getResponse();
        response.reset();
        response.setContentType(this.contentType);
        response.setHeader("Content-Disposition", "attachment; filename=\"" + System.currentTimeMillis() + ".xls\"");
        InputStream in = null;
        try {
            OgnlValueStack stack = invocation.getStack();
            in = this.getTemplate(invocation, location, stack);
            ServletOutputStream out = response.getOutputStream();
            Object context = ExcelManager.getInstance().buildContextObject(stack);
            ExcelUtils.export(in, context, (OutputStream)out);
            out.flush();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    protected InputStream getTemplate(ActionInvocation invocation, String location, OgnlValueStack stack) {
        return ExcelManager.getInstance().getExcel(ServletActionContext.getServletContext(), location);
    }
}

