/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.column;

import com.github.jasync.sql.db.column.ColumnEncoderDecoder;
import com.github.jasync.sql.db.general.ColumnData;
import com.github.jasync.sql.db.util.EncodingUtilsKt;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0016\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/github/jasync/sql/db/column/TimeEncoderDecoder;", "Lcom/github/jasync/sql/db/column/ColumnEncoderDecoder;", "()V", "format", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "printer", "decode", "Ljava/time/LocalTime;", "value", "", "encode", "", "formatter", "Companion", "jasync-common"})
public class TimeEncoderDecoder
implements ColumnEncoderDecoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final DateTimeFormatter format = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").appendOptional(EncodingUtilsKt.getMicrosecondsFormatter()).toFormatter();
    private final DateTimeFormatter printer = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss.SSSSSS").toFormatter();
    @NotNull
    private static final TimeEncoderDecoder Instance = new TimeEncoderDecoder();

    public DateTimeFormatter formatter() {
        return this.format;
    }

    @Override
    @NotNull
    public LocalTime decode(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        LocalTime localTime = LocalTime.parse(value, this.formatter());
        Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"parse(value, formatter())");
        return localTime;
    }

    @Override
    @NotNull
    public String encode(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = ((LocalTime)value).format(this.printer);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value as LocalTime).format(printer)");
        return string;
    }

    @Override
    @Nullable
    public Object decode(@NotNull ColumnData kind, @NotNull ByteBuf value, @NotNull Charset charset) {
        return ColumnEncoderDecoder.DefaultImpls.decode(this, kind, value, charset);
    }

    @Override
    public boolean supportsStringDecoding() {
        return ColumnEncoderDecoder.DefaultImpls.supportsStringDecoding(this);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/jasync/sql/db/column/TimeEncoderDecoder$Companion;", "", "()V", "Instance", "Lcom/github/jasync/sql/db/column/TimeEncoderDecoder;", "getInstance", "()Lcom/github/jasync/sql/db/column/TimeEncoderDecoder;", "jasync-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TimeEncoderDecoder getInstance() {
            return Instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

