/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.DataFrame;
import data.DataType;
import data.Schema;
import data.Types;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

final class CsvData {
    private final File csvFile;
    private final List<CSVRecord> parsedRecords;
    private final List<String> header;

    CsvData(String csvFilePath) {
        this(csvFilePath, false);
    }

    CsvData(String csvFilePath, boolean headerRow) {
        List records;
        URL resource = this.getClass().getClassLoader().getResource(csvFilePath);
        if (resource == null) {
            throw new IllegalArgumentException("The resource given by " + csvFilePath + " could not be found on the file system.");
        }
        this.csvFile = new File(resource.getFile());
        CSVParser parser = this.getParser(this.csvFile);
        if (parser == null) {
            throw new IllegalArgumentException("The resource given by " + csvFilePath + " could not be found on the file system.");
        }
        try {
            records = parser.getRecords();
        }
        catch (IOException ie) {
            throw new RuntimeException("The csv parser failed to retrieve the records.");
        }
        finally {
            try {
                parser.close();
            }
            catch (IOException ie) {
                ie.printStackTrace();
            }
        }
        if (headerRow) {
            this.header = new ArrayList<String>();
            CSVRecord headerRecord = (CSVRecord)records.remove(0);
            for (String s : headerRecord) {
                this.header.add(s);
            }
        } else {
            this.header = Collections.emptyList();
        }
        this.parsedRecords = records;
    }

    private CSVParser getParser(File csvFile) {
        try {
            return CSVParser.parse((File)csvFile, (Charset)Charset.defaultCharset(), (CSVFormat)CSVFormat.DEFAULT);
        }
        catch (IOException ie) {
            ie.printStackTrace();
            System.out.println("Error parsing csv file. Path : " + csvFile.getAbsolutePath());
            return null;
        }
    }

    File csvFile() {
        return this.csvFile;
    }

    List<CSVRecord> getRows() {
        return this.parsedRecords;
    }

    CSVRecord getRow(int i) {
        return this.parsedRecords.get(i);
    }

    List<String> getColumn(int i) {
        ArrayList<String> column = new ArrayList<String>(this.parsedRecords.size());
        for (CSVRecord record : this.parsedRecords) {
            column.add(record.get(i));
        }
        return column;
    }

    List<String> getHeader() {
        return Collections.unmodifiableList(this.header);
    }

    List<List<String>> getColumns() {
        int nCols = this.parsedRecords.get(0).size();
        ArrayList<List<String>> columns = new ArrayList<List<String>>(nCols);
        for (int i = 0; i < nCols; ++i) {
            ArrayList<String> column = new ArrayList<String>(this.parsedRecords.size());
            for (CSVRecord row : this.parsedRecords) {
                column.add(row.get(i));
            }
            columns.add(column);
        }
        return columns;
    }

    List<String> getColumn(String columnName) {
        List<String> headerRow = this.getHeader();
        for (int i = 0; i < headerRow.size(); ++i) {
            if (!headerRow.get(i).equals(columnName)) continue;
            return this.getColumn(i);
        }
        throw new IllegalArgumentException("A column with the name " + columnName + " was not found.");
    }

    DataFrame createDataFrame(Schema schema) {
        List<List<String>> columns = this.getColumns();
        if (schema.size() != columns.size()) {
            throw new IllegalArgumentException("The schema size was " + schema.size() + " but the number of columns was " + columns.size() + ". There must be one data type for each column.");
        }
        DataFrame df = new DataFrame(schema.size());
        int colId = 0;
        List<String> header = this.getHeader();
        block7: for (int i = 0; i < schema.size(); ++i) {
            DataType type = schema.get(i);
            String stringColId = header.isEmpty() ? Integer.toString(colId++) : header.get(i);
            List<String> column = columns.get(i);
            switch (type) {
                case DOUBLE: {
                    Double[] doubles = Types.toDoubleArray(column);
                    df.add(stringColId, Double[].class, doubles);
                    continue block7;
                }
                case BOOLEAN: {
                    Boolean[] booleans = Types.toBooleanArray(column);
                    df.add(stringColId, Boolean[].class, booleans);
                    continue block7;
                }
                case LOCAL_DATE_TIME: {
                    LocalDateTime[] localDateTimes = Types.toLocalDateTimeArray(column);
                    df.add(stringColId, LocalDateTime[].class, localDateTimes);
                    continue block7;
                }
                case OFFSET_DATE_TIME: {
                    OffsetDateTime[] offsetDateTimes = Types.toOffsetDateTimeArray(column);
                    df.add(stringColId, OffsetDateTime[].class, offsetDateTimes);
                    continue block7;
                }
                case STRING: {
                    df.add(stringColId, String[].class, Types.toStringArray(column));
                    continue block7;
                }
                default: {
                    df.add(stringColId, String[].class, Types.toStringArray(column));
                }
            }
        }
        return df;
    }

    DataFrame createDataFrame() {
        List<List<String>> columns = this.getColumns();
        DataFrame df = new DataFrame(columns.size());
        int colId = 0;
        List<String> header = this.getHeader();
        for (int i = 0; i < columns.size(); ++i) {
            String stringColId = header.isEmpty() ? Integer.toString(colId++) : header.get(i);
            List<String> column = columns.get(i);
            df.add(stringColId, String[].class, Types.toStringArray(column));
        }
        return df;
    }
}

