/*
 * Decompiled with CFR 0.152.
 */
package data;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class DataFrame {
    private final Map<String, ColumnInfo<?>> columnIdMap;
    private final Map<ColumnInfo<?>, Object> columnMap;

    DataFrame() {
        this.columnIdMap = new HashMap();
        this.columnMap = new HashMap();
    }

    DataFrame(int numColumns) {
        this.columnIdMap = new HashMap(numColumns);
        this.columnMap = new HashMap(numColumns);
    }

    public int size() {
        return this.columnMap.size();
    }

    public Set<String> getColumnIds() {
        return this.columnIdMap.keySet();
    }

    public <T> void add(String id, Class<T[]> type, T[] instance) {
        if (type == null) {
            throw new NullPointerException("The class type was null.");
        }
        if (this.columnIdMap.containsKey(id)) {
            throw new IllegalArgumentException("The column id, " + id + ", already exists. The column id must be unique.");
        }
        ColumnInfo colInfo = new ColumnInfo(id, type);
        this.columnIdMap.put(id, colInfo);
        this.columnMap.put(colInfo, instance);
    }

    <T> void replace(String id, Class<T[]> type, T[] instance) {
        if (type == null) {
            throw new NullPointerException("The class type was null.");
        }
        if (!this.columnIdMap.containsKey(id)) {
            throw new IllegalArgumentException("The column id, " + id + ", doesn't exist, so there is nothing to replace.");
        }
        ColumnInfo<?> oldInfo = this.columnIdMap.get(id);
        this.columnMap.remove(oldInfo);
        ColumnInfo colInfo = new ColumnInfo(id, type);
        this.columnIdMap.put(id, colInfo);
        this.columnMap.put(colInfo, instance);
    }

    <T> void add(String id, Class<T[]> type, List<T> instance) {
        if (type == null) {
            throw new NullPointerException("The class type was null.");
        }
        T[] asArray = type.cast(instance.toArray());
        ColumnInfo colInfo = new ColumnInfo(id, type);
        this.columnIdMap.put(id, colInfo);
        this.columnMap.put(colInfo, asArray);
    }

    <T> T[] remove(String id, Class<T[]> type) {
        return type.cast(this.columnMap.remove(new ColumnInfo(id, type)));
    }

    <T> List<T> getList(String id, Class<T[]> type) {
        ColumnInfo info = new ColumnInfo(id, type);
        T[] column = this.get(info);
        return Arrays.asList(column);
    }

    ColumnInfo<?> getColumnInfo(String id) {
        return this.columnIdMap.get(id);
    }

    Class<?> getColumnClass(String id) {
        return ((ColumnInfo)this.columnIdMap.get(id)).clazz;
    }

    String getColumnClassName(String id) {
        return ((ColumnInfo)this.columnIdMap.get(id)).clazz.getSimpleName();
    }

    public <T> T[] get(String id, Class<T[]> type) {
        ColumnInfo info = new ColumnInfo(id, type);
        return this.get(info);
    }

    public <T> T[] get(ColumnInfo<T> info) {
        return (Object[])((ColumnInfo)info).clazz.cast(this.columnMap.get(info));
    }

    public void print() {
        System.out.println(this.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataFrame dataFrame = (DataFrame)o;
        if (!this.columnIdMap.equals(dataFrame.columnIdMap)) {
            return false;
        }
        return this.columnMap.equals(dataFrame.columnMap);
    }

    public int hashCode() {
        int result = this.columnIdMap.hashCode();
        result = 31 * result + this.columnMap.hashCode();
        return result;
    }

    public static class ColumnInfo<T> {
        private final String columnId;
        private final Class<T[]> clazz;

        public ColumnInfo(String columnId, Class<T[]> clazz) {
            this.columnId = columnId;
            this.clazz = clazz;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColumnInfo that = (ColumnInfo)o;
            if (!this.columnId.equals(that.columnId)) {
                return false;
            }
            return this.clazz.equals(that.clazz);
        }

        public int hashCode() {
            int result = this.columnId.hashCode();
            result = 31 * result + this.clazz.hashCode();
            return result;
        }
    }
}

