/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.Types;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

enum DataType {
    BOOLEAN("Boolean"){

        @Override
        public Boolean convert(String s) {
            return Boolean.parseBoolean(s);
        }

        public List<Boolean> convertList(List<String> strings) {
            return Types.toBooleanList(strings);
        }

        public Boolean[] convert(List<String> strings) {
            return Types.toBooleanArray(strings);
        }
    }
    ,
    DOUBLE("Double"){

        @Override
        public Double convert(String s) {
            return Double.parseDouble(s);
        }

        public List<Double> convertList(List<String> strings) {
            return Types.toDoubleList(strings);
        }

        public Double[] convert(List<String> strings) {
            return Types.toDoubleArray(strings);
        }
    }
    ,
    LOCAL_DATE_TIME("LocalDateTime"){

        @Override
        public LocalDateTime convert(String s) {
            try {
                return LocalDateTime.parse(s);
            }
            catch (DateTimeParseException e) {
                System.out.println(e.getMessage());
                return null;
            }
        }

        public List<LocalDateTime> convertList(List<String> strings) {
            return Types.toLocalDateTimeList(strings);
        }

        public LocalDateTime[] convert(List<String> strings) {
            return Types.toLocalDateTimeArray(strings);
        }
    }
    ,
    OFFSET_DATE_TIME("OffsetDateTime"){

        @Override
        public OffsetDateTime convert(String s) {
            try {
                return OffsetDateTime.parse(s);
            }
            catch (DateTimeParseException e) {
                System.out.println(e.getMessage());
                return null;
            }
        }

        public List<OffsetDateTime> convertList(List<String> strings) {
            return Types.toOffsetDateTimeList(strings);
        }

        public OffsetDateTime[] convert(List<String> strings) {
            return Types.toOffsetDateTimeArray(strings);
        }
    }
    ,
    STRING("String"){

        @Override
        public String convert(String s) {
            return s;
        }

        public List<String> convertList(List<String> strings) {
            return new ArrayList<String>(strings);
        }

        public String[] convert(List<String> strings) {
            return (String[])String[].class.cast(strings.toArray());
        }
    };

    private static final Map<String, DataType> stringToEnum;
    private final String symbol;

    private DataType(String symbol) {
        this.symbol = symbol;
    }

    public static DataType fromString(String symbol) {
        return stringToEnum.get(symbol);
    }

    public String toString() {
        return this.symbol;
    }

    public abstract List<?> convertList(List<String> var1);

    public abstract Object[] convert(List<String> var1);

    public abstract Object convert(String var1);

    static {
        stringToEnum = new HashMap<String, DataType>();
        for (DataType dt : DataType.values()) {
            stringToEnum.put(dt.toString(), dt);
        }
    }
}

