/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.DataSet;
import data.Operators;
import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import java.util.Arrays;
import javax.swing.JFrame;
import org.knowm.xchart.XChartPanel;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;
import stats.Statistics;

public final class DoubleDataSet
implements DataSet {
    private final double[] data;

    public DoubleDataSet(double ... data) {
        if (data == null) {
            throw new NullPointerException("Null array passed to DoubleDataSet constructor.");
        }
        this.data = (double[])data.clone();
    }

    @Override
    public final double sum() {
        return Statistics.sumOf(this.data);
    }

    @Override
    public final double sumOfSquares() {
        return Statistics.sumOfSquared(this.data);
    }

    @Override
    public final double mean() {
        return Statistics.meanOf(this.data);
    }

    @Override
    public final double median() {
        return Statistics.medianOf(this.data);
    }

    @Override
    public final int n() {
        return this.data.length;
    }

    @Override
    public final DataSet times(DataSet otherData) {
        return new DoubleDataSet(Operators.productOf(this.data, otherData.asArray()));
    }

    @Override
    public final DataSet plus(DataSet otherData) {
        return new DoubleDataSet(Operators.sumOf(this.data, otherData.asArray()));
    }

    @Override
    public final double variance() {
        return Statistics.varianceOf(this.data);
    }

    @Override
    public final double stdDeviation() {
        return Statistics.stdDeviationOf(this.data);
    }

    @Override
    public final double covariance(DataSet otherData) {
        return Statistics.covarianceOf(this.data, otherData.asArray());
    }

    @Override
    public final double correlation(DataSet otherData) {
        return Statistics.correlationOf(this.data, otherData.asArray());
    }

    @Override
    public final double[] asArray() {
        return (double[])this.data.clone();
    }

    @Override
    public void plot() {
        new Thread(() -> {
            double[] indices = new double[this.data.length];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = i;
            }
            XYChart chart = ((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().theme(Styler.ChartTheme.GGPlot2)).title("Scatter Plot")).xAxisTitle("Index").yAxisTitle("Values").build();
            ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter).setChartFontColor(Color.BLACK).setSeriesColors(new Color[]{Color.BLUE});
            chart.addSeries("data", indices, this.data);
            XChartPanel panel = new XChartPanel((Chart)chart);
            JFrame frame = new JFrame("Data Set");
            frame.setDefaultCloseOperation(2);
            frame.add((Component)panel);
            frame.pack();
            frame.setVisible(true);
        }).run();
    }

    @Override
    public void plotAgainst(DataSet otherData) {
        new Thread(() -> {
            XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().theme(Styler.ChartTheme.GGPlot2)).height(600)).width(800)).title("Scatter Plot")).xAxisTitle("X").yAxisTitle("Y").build();
            ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter).setChartFontColor(Color.DARK_GRAY).setSeriesColors(new Color[]{Color.BLUE});
            chart.addSeries("Y against X", otherData.asArray(), this.data);
            XChartPanel panel = new XChartPanel((Chart)chart);
            JFrame frame = new JFrame("Scatter Plot");
            frame.setDefaultCloseOperation(2);
            frame.add((Component)panel);
            frame.pack();
            frame.setVisible(true);
        }).run();
    }

    public String toString() {
        DecimalFormat df = new DecimalFormat("0.##");
        return "\nValues: " + Arrays.toString(this.data) + "\nLength: " + this.data.length + "\nMean: " + this.mean() + "\nStandard deviation: " + df.format(this.stdDeviation());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DoubleDataSet other = (DoubleDataSet)obj;
        return Arrays.equals(this.data, other.data);
    }
}

