/*
 * Decompiled with CFR 0.152.
 */
package data;

import com.google.common.primitives.Doubles;
import java.util.List;
import stats.Statistics;

public final class DoubleFunctions {
    private static final double EPSILON = Math.ulp(1.0);

    private DoubleFunctions() {
    }

    public static double[] arrayFrom(double ... data) {
        return (double[])data.clone();
    }

    public static double[] combine(double[] ... arrays) {
        int newArrayLength = 0;
        for (double[] array : arrays) {
            newArrayLength += array.length;
        }
        double[] newArray = new double[newArrayLength];
        newArrayLength = 0;
        for (double[] array : arrays) {
            System.arraycopy(array, 0, newArray, newArrayLength, array.length);
            newArrayLength += array.length;
        }
        return newArray;
    }

    public static double[] append(double[] original, double value) {
        double[] newArray = new double[original.length + 1];
        System.arraycopy(original, 0, newArray, 0, original.length);
        newArray[original.length] = value;
        return newArray;
    }

    public static double[] arrayFrom(List<Double> data) {
        int size = data.size();
        double[] doubles = new double[size];
        for (int i = 0; i < size; ++i) {
            doubles[i] = data.get(i);
        }
        return doubles;
    }

    public static double[] arrayFrom(Double[] data) {
        int size = data.length;
        double[] doubles = new double[size];
        for (int i = 0; i < size; ++i) {
            doubles[i] = data[i];
        }
        return doubles;
    }

    public static double[] fill(int size, double value) {
        double[] filled = new double[size];
        for (int i = 0; i < filled.length; ++i) {
            filled[i] = value;
        }
        return filled;
    }

    public static List<Double> listFrom(double ... data) {
        return Doubles.asList((double[])((double[])data.clone()));
    }

    public static double[] slice(double[] data, int from, int to) {
        double[] sliced = new double[to - from];
        System.arraycopy(data, from, sliced, 0, to - from);
        return sliced;
    }

    public static double[] boxCox(double[] data, double lambda) {
        double[] boxCoxed = new double[data.length];
        if (Math.abs(lambda) < EPSILON) {
            for (int i = 0; i < boxCoxed.length; ++i) {
                boxCoxed[i] = Math.log(data[i]);
            }
        } else {
            for (int i = 0; i < boxCoxed.length; ++i) {
                boxCoxed[i] = (Math.pow(data[i], lambda) - 1.0) / lambda;
            }
        }
        return boxCoxed;
    }

    public static double[] inverseBoxCox(double[] data, double lambda) {
        double[] invBoxCoxed = new double[data.length];
        if (Math.abs(lambda) < EPSILON) {
            for (int i = 0; i < invBoxCoxed.length; ++i) {
                invBoxCoxed[i] = Math.exp(data[i]);
            }
        } else {
            for (int i = 0; i < invBoxCoxed.length; ++i) {
                invBoxCoxed[i] = Math.pow(data[i] * lambda + 1.0, 1.0 / lambda);
            }
        }
        return invBoxCoxed;
    }

    public static double[] sqrt(double ... data) {
        double[] sqrtData = new double[data.length];
        for (int i = 0; i < sqrtData.length; ++i) {
            sqrtData[i] = Math.sqrt(data[i]);
        }
        return sqrtData;
    }

    public static double round(double value, int precision) {
        double scale = Math.pow(10.0, precision);
        return (double)Math.round(value * scale) / scale;
    }

    public static double[] round(double[] values, int precision) {
        double[] rounded = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            rounded[i] = DoubleFunctions.round(values[i], precision);
        }
        return rounded;
    }

    static double[] demean(double[] data) {
        double mean = Statistics.meanOf(data);
        double[] demeaned = new double[data.length];
        for (int t = 0; t < data.length; ++t) {
            demeaned[t] = data[t] - mean;
        }
        return demeaned;
    }

    static double[] negativeOf(double[] data) {
        double[] negative = new double[data.length];
        for (int i = 0; i < negative.length; ++i) {
            negative[i] = -data[i];
        }
        return negative;
    }
}

