/*
 * Decompiled with CFR 0.152.
 */
package data;

import com.google.common.primitives.Doubles;
import data.DoubleFunctions;
import java.awt.Color;
import java.awt.Component;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JFrame;
import org.knowm.xchart.XChartPanel;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.markers.Circle;
import org.knowm.xchart.style.markers.Marker;
import timeseries.TimeSeries;

public class Plots {
    private Plots() {
    }

    public static void plot(TimeSeries timeSeries, String title, String seriesName) {
        new Thread(() -> {
            ArrayList<Date> xAxis = new ArrayList<Date>(timeSeries.observationTimes().size());
            for (OffsetDateTime dateTime : timeSeries.observationTimes()) {
                xAxis.add(Date.from(dateTime.toInstant()));
            }
            List seriesList = Doubles.asList((double[])DoubleFunctions.round(timeSeries.asArray(), 2));
            XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().theme(Styler.ChartTheme.GGPlot2)).height(600)).width(800)).title(title)).build();
            XYSeries residualSeries = chart.addSeries(seriesName, xAxis, seriesList);
            residualSeries.setXYSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter);
            residualSeries.setMarker((Marker)new Circle()).setMarkerColor(Color.RED);
            XChartPanel panel = new XChartPanel((Chart)chart);
            JFrame frame = new JFrame(title);
            frame.setDefaultCloseOperation(2);
            frame.add((Component)panel);
            frame.pack();
            frame.setVisible(true);
        }).start();
    }
}

