/*
 * Decompiled with CFR 0.152.
 */
package data;

import com.google.common.primitives.Doubles;
import java.util.Arrays;
import java.util.List;
import stats.Statistics;

public final class Range {
    private final double[] range;
    private final double by;

    public Range(double from, double to, double by) {
        if (by <= 0.0) {
            throw new IllegalArgumentException("The by argument must be non-negative.");
        }
        this.by = by;
        int size = (int)Math.abs((to - from) / by) + 1;
        this.range = new double[size];
        for (int i = 0; i < this.range.length; ++i) {
            this.range[i] = from + Math.signum(to - from) * (double)i * by;
        }
    }

    public static Range exclusiveRange(int from, int to) {
        return new Range(from, to - 1, 1.0);
    }

    public static Range inclusiveRange(int from, int to) {
        return new Range(from, to, 1.0);
    }

    public double[] asArray() {
        return (double[])this.range.clone();
    }

    public List<Double> asList() {
        return Doubles.asList((double[])((double[])this.range.clone()));
    }

    public double sum() {
        return Statistics.sumOf(this.range);
    }

    public int size() {
        return this.range.length;
    }

    public double start() {
        return this.range[0];
    }

    public double end() {
        return this.range[this.range.length - 1];
    }

    public double at(int i) {
        return this.range[i];
    }

    public String toString() {
        return String.format("Range: %s to %s by %s", Double.toString(this.range[0]), Double.toString(this.range[this.range.length - 1]), Double.toString(this.by));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range other = (Range)o;
        if (!Arrays.equals(this.range, other.range)) {
            return false;
        }
        return Double.compare(this.by, other.by) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.range);
        long $by = Double.doubleToLongBits(this.by);
        result = result * 59 + (int)($by >>> 32 ^ $by);
        return result;
    }
}

