/*
 * Decompiled with CFR 0.152.
 */
package data;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

final class Types {
    private Types() {
    }

    static boolean isDouble(String pi) {
        String Digits = "(\\p{Digit}+)";
        String HexDigits = "(\\p{XDigit}+)";
        String Exp = "[eE][+-]?(\\p{Digit}+)";
        String fpRegex = "[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*";
        return Pattern.matches("[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*", pi);
    }

    static List<Double> toDoubleList(List<String> strings) {
        ArrayList<Double> doubles = new ArrayList<Double>(strings.size());
        for (String s : strings) {
            doubles.add(Double.valueOf(s));
        }
        return doubles;
    }

    static Double[] toDoubleArray(List<String> strings) {
        Double[] doubles = new Double[strings.size()];
        for (int i = 0; i < doubles.length; ++i) {
            doubles[i] = Double.valueOf(strings.get(i));
        }
        return doubles;
    }

    static String[] toStringArray(List<String> strings) {
        String[] stringArray = new String[strings.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = strings.get(i);
        }
        return stringArray;
    }

    static boolean isLocalDateTime(String s) {
        try {
            LocalDateTime.parse(s);
        }
        catch (DateTimeParseException e) {
            return false;
        }
        return true;
    }

    static boolean isOffsetDateTime(String s) {
        try {
            OffsetDateTime.parse(s);
        }
        catch (DateTimeParseException e) {
            return false;
        }
        return true;
    }

    static List<OffsetDateTime> toOffsetDateTimeList(List<String> strings) {
        ArrayList<OffsetDateTime> dateTimes = new ArrayList<OffsetDateTime>(strings.size());
        for (String s : strings) {
            dateTimes.add(OffsetDateTime.parse(s));
        }
        return dateTimes;
    }

    static OffsetDateTime[] toOffsetDateTimeArray(List<String> strings) {
        OffsetDateTime[] dateTimes = new OffsetDateTime[strings.size()];
        for (int i = 0; i < dateTimes.length; ++i) {
            dateTimes[i] = OffsetDateTime.parse(strings.get(i));
        }
        return dateTimes;
    }

    static List<LocalDateTime> toLocalDateTimeList(List<String> strings) {
        ArrayList<LocalDateTime> dateTimes = new ArrayList<LocalDateTime>(strings.size());
        for (String s : strings) {
            dateTimes.add(LocalDateTime.parse(s));
        }
        return dateTimes;
    }

    static LocalDateTime[] toLocalDateTimeArray(List<String> strings) {
        LocalDateTime[] dateTimes = new LocalDateTime[strings.size()];
        for (int i = 0; i < dateTimes.length; ++i) {
            dateTimes[i] = LocalDateTime.parse(strings.get(i));
        }
        return dateTimes;
    }

    static List<Boolean> toBooleanList(List<String> strings) {
        ArrayList<Boolean> booleans = new ArrayList<Boolean>(strings.size());
        for (String s : strings) {
            booleans.add(Boolean.parseBoolean(s));
        }
        return booleans;
    }

    static Boolean[] toBooleanArray(List<String> strings) {
        Boolean[] booleans = new Boolean[strings.size()];
        for (int i = 0; i < booleans.length; ++i) {
            booleans[i] = Boolean.parseBoolean(strings.get(i));
        }
        return booleans;
    }
}

