/*
 * Decompiled with CFR 0.152.
 */
package linear.doubles;

import java.util.Arrays;
import linear.doubles.Vector;

public final class Matrix {
    private final int nrow;
    private final int ncol;
    private final double[] data;

    Matrix(int nrow, int ncol, double ... data) {
        if (nrow * ncol != data.length) {
            throw new IllegalArgumentException("The dimensions do not match the amount of data provided. There were " + data.length + " data points provided but the number of rows and columns were " + nrow + " and " + ncol + " respectively.");
        }
        this.nrow = nrow;
        this.ncol = ncol;
        this.data = (double[])data.clone();
    }

    public Matrix(int nrow, int ncol, double value) {
        this.nrow = nrow;
        this.ncol = ncol;
        this.data = new double[nrow * ncol];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = value;
        }
    }

    Matrix(double[][] matrixData) {
        this.nrow = matrixData.length;
        this.ncol = matrixData[0].length;
        this.data = new double[this.nrow * this.ncol];
        for (int i = 0; i < this.nrow; ++i) {
            System.arraycopy(matrixData[i], 0, this.data, i * this.ncol, this.ncol);
        }
    }

    public static Matrix create(int nrow, int ncol, double[] data) {
        return new Matrix(nrow, ncol, data);
    }

    public Matrix plus(Matrix other) {
        if (this.nrow != other.nrow || this.ncol != other.ncol) {
            throw new IllegalArgumentException("The dimensions of this matrix must equal the dimensions of the other matrix. This matrix has dimension (" + this.nrow + ", " + this.ncol + ") and the other matrix has dimension (" + other.nrow + ", " + other.ncol + ")");
        }
        double[] sum = new double[this.nrow * this.ncol];
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                sum[i * this.ncol + j] = this.data[i * this.ncol + j] + other.data[i * this.ncol + j];
            }
        }
        return new Matrix(this.nrow, this.ncol, sum);
    }

    public Matrix times(Matrix other) {
        if (this.ncol != other.nrow) {
            throw new IllegalArgumentException("The columns of this matrix must equal the rows of the other matrix. This matrix has " + this.ncol + " columns and the other matrix has " + other.nrow + " rows.");
        }
        double[] product = new double[this.nrow * other.ncol];
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < other.ncol; ++j) {
                for (int k = 0; k < this.ncol; ++k) {
                    int n = i * this.nrow + j;
                    product[n] = product[n] + this.data[i * this.ncol + k] * other.data[j + k * other.ncol];
                }
            }
        }
        return new Matrix(this.nrow, other.ncol, product);
    }

    public Vector times(Vector vector) {
        double[] elements = vector.elements();
        if (this.ncol != elements.length) {
            throw new IllegalArgumentException("The columns of this matrix must equal the rows of the vector. This matrix has " + this.ncol + " columns and the vector has " + elements.length + " rows.");
        }
        double[] product = new double[this.nrow];
        for (int i = 0; i < this.nrow; ++i) {
            for (int k = 0; k < this.ncol; ++k) {
                int n = i;
                product[n] = product[n] + this.data[i * this.ncol + k] * elements[k];
            }
        }
        return new Vector(product);
    }

    public Matrix scaledBy(double c) {
        double[] scaled = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            scaled[i] = this.data[i] * c;
        }
        return new Matrix(this.nrow, this.ncol, scaled);
    }

    public Matrix minus(Matrix other) {
        if (this.nrow != other.nrow || this.ncol != other.ncol) {
            throw new IllegalArgumentException("The dimensions of this matrix must equal the dimensions of the other matrix. This matrix has dimension (" + this.nrow + ", " + this.ncol + ") and the other matrix has dimension (" + other.nrow + ", " + other.ncol + ")");
        }
        double[] minus = new double[this.nrow * this.ncol];
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                minus[i * this.ncol + j] = this.data[i * this.ncol + j] - other.data[i * this.ncol + j];
            }
        }
        return new Matrix(this.nrow, this.ncol, minus);
    }

    boolean isSquare() {
        return this.nrow == this.ncol;
    }

    Matrix transpose() {
        double[] tData = new double[this.data.length];
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                tData[i + j * this.nrow] = this.data[j + i * this.ncol];
            }
        }
        return new Matrix(this.ncol, this.nrow, tData);
    }

    public double[] diagonal() {
        double[] diag = new double[Math.min(this.nrow, this.ncol)];
        for (int i = 0; i < diag.length; ++i) {
            diag[i] = this.data[this.ncol * i + i];
        }
        return diag;
    }

    public double[] data() {
        return (double[])this.data.clone();
    }

    double[][] data2D() {
        double[][] twoD = new double[this.nrow][this.ncol];
        for (int i = 0; i < this.nrow; ++i) {
            System.arraycopy(this.data, i * this.ncol, twoD[i], 0, this.ncol);
        }
        return twoD;
    }

    public String toString() {
        StringBuilder representation = new StringBuilder();
        double[][] twoD = this.data2D();
        for (int i = 0; i < this.nrow; ++i) {
            representation.append(Arrays.toString(twoD[i])).append("\n");
        }
        return representation.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Matrix matrix = (Matrix)o;
        return this.nrow == matrix.nrow && this.ncol == matrix.ncol && Arrays.equals(this.data, matrix.data);
    }

    public int hashCode() {
        int result = this.nrow;
        result = 31 * result + this.ncol;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public static final class IdentityBuilder {
        final int n;
        final double[] data;

        public IdentityBuilder(int n) {
            this.n = n;
            this.data = new double[n * n];
            for (int i = 0; i < n; ++i) {
                this.data[i * n + i] = 1.0;
            }
        }

        public IdentityBuilder set(int i, int j, double value) {
            this.data[i * this.n + j] = value;
            return this;
        }

        public Matrix build() {
            return new Matrix(this.n, this.n, this.data);
        }
    }
}

