/*
 * Decompiled with CFR 0.152.
 */
package linear.regression;

import com.google.common.collect.ImmutableList;
import data.DoubleFunctions;
import java.util.ArrayList;
import java.util.List;
import linear.regression.LinearRegression;
import org.ejml.alg.dense.mult.MatrixVectorMult;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.LinearSolverFactory;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.interfaces.linsol.LinearSolver;
import org.ejml.ops.CommonOps;
import stats.Statistics;

public final class MultipleLinearRegression
implements LinearRegression {
    private final List<List<Double>> predictors;
    private final List<Double> response;
    private final List<Double> beta;
    private final List<Double> standardErrors;
    private final List<Double> fitted;
    private final List<Double> residuals;
    private final double sigma2;
    private final boolean hasIntercept;

    private MultipleLinearRegression(Builder builder) {
        this.predictors = builder.listBuilder.build();
        this.response = builder.response;
        this.hasIntercept = builder.hasIntercept;
        MatrixFormulation matrixFormulation = new MatrixFormulation();
        this.beta = matrixFormulation.getBetaEstimates();
        this.fitted = matrixFormulation.getFittedvalues();
        this.residuals = matrixFormulation.getResiduals();
        this.sigma2 = matrixFormulation.getSigma2();
        this.standardErrors = matrixFormulation.getBetaStandardErrors(this.beta.size());
    }

    @Override
    public List<List<Double>> predictors() {
        return this.predictors;
    }

    @Override
    public List<Double> beta() {
        return ImmutableList.copyOf(this.beta);
    }

    @Override
    public List<Double> standardErrors() {
        return ImmutableList.copyOf(this.standardErrors);
    }

    @Override
    public List<Double> response() {
        return this.response;
    }

    @Override
    public List<Double> fitted() {
        return ImmutableList.copyOf(this.fitted);
    }

    @Override
    public List<Double> residuals() {
        return ImmutableList.copyOf(this.residuals);
    }

    @Override
    public double sigma2() {
        return this.sigma2;
    }

    @Override
    public boolean hasIntercept() {
        return this.hasIntercept;
    }

    public MultipleLinearRegression withHasIntercept(boolean hasIntercept) {
        return new Builder().from(this).hasIntercept(hasIntercept).build();
    }

    public MultipleLinearRegression withResponse(List<Double> response) {
        return new Builder().from(this).response(response).build();
    }

    public MultipleLinearRegression withPredictor(List<Double> predictor) {
        return new Builder().from(this).predictor(predictor).build();
    }

    public MultipleLinearRegression withPredictors(List<List<Double>> predictors) {
        return new Builder().from(this).predictors(predictors).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultipleLinearRegression)) {
            return false;
        }
        MultipleLinearRegression other = (MultipleLinearRegression)o;
        List<List<Double>> this$predictors = this.predictors;
        List<List<Double>> other$predictors = other.predictors;
        if (this$predictors == null ? other$predictors != null : !((Object)this$predictors).equals(other$predictors)) {
            return false;
        }
        List<Double> this$response = this.response;
        List<Double> other$response = other.response;
        if (this$response == null ? other$response != null : !((Object)this$response).equals(other$response)) {
            return false;
        }
        List<Double> this$beta = this.beta;
        List<Double> other$beta = other.beta;
        if (this$beta == null ? other$beta != null : !((Object)this$beta).equals(other$beta)) {
            return false;
        }
        List<Double> this$standardErrors = this.standardErrors;
        List<Double> other$standardErrors = other.standardErrors;
        if (this$standardErrors == null ? other$standardErrors != null : !((Object)this$standardErrors).equals(other$standardErrors)) {
            return false;
        }
        List<Double> this$fitted = this.fitted;
        List<Double> other$fitted = other.fitted;
        if (this$fitted == null ? other$fitted != null : !((Object)this$fitted).equals(other$fitted)) {
            return false;
        }
        List<Double> this$residuals = this.residuals;
        List<Double> other$residuals = other.residuals;
        if (this$residuals == null ? other$residuals != null : !((Object)this$residuals).equals(other$residuals)) {
            return false;
        }
        if (Double.compare(this.sigma2, other.sigma2) != 0) {
            return false;
        }
        return this.hasIntercept == other.hasIntercept;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<List<Double>> $predictors = this.predictors;
        result = result * 59 + ($predictors == null ? 43 : ((Object)$predictors).hashCode());
        List<Double> $response = this.response;
        result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
        List<Double> $beta = this.beta;
        result = result * 59 + ($beta == null ? 43 : ((Object)$beta).hashCode());
        List<Double> $standardErrors = this.standardErrors;
        result = result * 59 + ($standardErrors == null ? 43 : ((Object)$standardErrors).hashCode());
        List<Double> $fitted = this.fitted;
        result = result * 59 + ($fitted == null ? 43 : ((Object)$fitted).hashCode());
        List<Double> $residuals = this.residuals;
        result = result * 59 + ($residuals == null ? 43 : ((Object)$residuals).hashCode());
        long $sigma2 = Double.doubleToLongBits(this.sigma2);
        result = result * 59 + (int)($sigma2 >>> 32 ^ $sigma2);
        result = result * 59 + (this.hasIntercept ? 79 : 97);
        return result;
    }

    public String toString() {
        return "MultipleLinearRegression(predictors=" + this.predictors + ", response=" + this.response + ", beta=" + this.beta + ", standardErrors=" + this.standardErrors + ", fitted=" + this.fitted + ", residuals=" + this.residuals + ", sigma2=" + this.sigma2 + ", hasIntercept=" + this.hasIntercept + ")";
    }

    private class MatrixFormulation {
        private final DenseMatrix64F A;
        private final DenseMatrix64F At;
        private final DenseMatrix64F AtAInv;
        private final DenseMatrix64F b;
        private final DenseMatrix64F y;
        private final D1Matrix64F fitted;
        private final List<Double> residuals;
        private final double sigma2;
        private final DenseMatrix64F covarianceMatrix;

        private MatrixFormulation() {
            int numRows = MultipleLinearRegression.this.response.size();
            int numCols = MultipleLinearRegression.this.predictors.size() + (MultipleLinearRegression.this.hasIntercept() ? 1 : 0);
            this.A = this.createMatrixA(numRows, numCols);
            this.At = new DenseMatrix64F(numCols, numRows);
            CommonOps.transpose((DenseMatrix64F)this.A, (DenseMatrix64F)this.At);
            this.AtAInv = new DenseMatrix64F(numCols, numCols);
            this.b = new DenseMatrix64F(numCols, 1);
            this.y = new DenseMatrix64F(numRows, 1);
            this.solveSystem(numRows, numCols);
            this.fitted = this.computeFittedValues();
            this.residuals = this.computeResiduals();
            this.sigma2 = this.estimateSigma2(numCols);
            this.covarianceMatrix = new DenseMatrix64F(numCols, numCols);
            CommonOps.scale((double)this.sigma2, (D1Matrix64F)this.AtAInv, (D1Matrix64F)this.covarianceMatrix);
        }

        private void solveSystem(int numRows, int numCols) {
            LinearSolver qrSolver = LinearSolverFactory.qr((int)numRows, (int)numCols);
            QRDecomposition decomposition = (QRDecomposition)qrSolver.getDecomposition();
            qrSolver.setA((Matrix)this.A);
            this.y.setData(DoubleFunctions.arrayFrom(MultipleLinearRegression.this.response));
            qrSolver.solve((Matrix)this.y, (Matrix)this.b);
            DenseMatrix64F R = (DenseMatrix64F)decomposition.getR(null, true);
            LinearSolver linearSolver = LinearSolverFactory.linear((int)numCols);
            linearSolver.setA((Matrix)R);
            DenseMatrix64F Rinverse = new DenseMatrix64F(numCols, numCols);
            linearSolver.invert((Matrix)Rinverse);
            CommonOps.multOuter((RowD1Matrix64F)Rinverse, (RowD1Matrix64F)this.AtAInv);
        }

        private DenseMatrix64F createMatrixA(int numRows, int numCols) {
            double[] data = MultipleLinearRegression.this.hasIntercept ? DoubleFunctions.fill(numRows, 1.0) : DoubleFunctions.arrayFrom(new double[0]);
            for (List predictor : MultipleLinearRegression.this.predictors) {
                data = DoubleFunctions.combine(data, DoubleFunctions.arrayFrom(predictor));
            }
            boolean isRowMajor = false;
            return new DenseMatrix64F(numRows, numCols, isRowMajor, data);
        }

        private D1Matrix64F computeFittedValues() {
            DenseMatrix64F fitted = new DenseMatrix64F(MultipleLinearRegression.this.response.size(), 1);
            MatrixVectorMult.mult((RowD1Matrix64F)this.A, (D1Matrix64F)this.b, (D1Matrix64F)fitted);
            return fitted;
        }

        private List<Double> computeResiduals() {
            List<Double> fitted = this.getFittedvalues();
            ArrayList<Double> residuals = new ArrayList<Double>(fitted.size());
            for (int i = 0; i < fitted.size(); ++i) {
                residuals.add((Double)MultipleLinearRegression.this.response.get(i) - fitted.get(i));
            }
            return residuals;
        }

        private double estimateSigma2(int df) {
            double ssq = Statistics.sumOfSquared(DoubleFunctions.arrayFrom(this.residuals));
            return ssq / (double)(this.residuals.size() - df);
        }

        private List<Double> getFittedvalues() {
            return DoubleFunctions.listFrom(this.fitted.getData());
        }

        private List<Double> getResiduals() {
            return this.residuals;
        }

        private List<Double> getBetaEstimates() {
            return DoubleFunctions.listFrom(this.b.getData());
        }

        private List<Double> getBetaStandardErrors(int numCols) {
            DenseMatrix64F diag = new DenseMatrix64F(numCols, 1);
            CommonOps.extractDiag((DenseMatrix64F)this.covarianceMatrix, (DenseMatrix64F)diag);
            return DoubleFunctions.listFrom(DoubleFunctions.sqrt(diag.getData()));
        }

        private double getSigma2() {
            return this.sigma2;
        }
    }

    public static final class Builder {
        private ImmutableList.Builder<List<Double>> listBuilder;
        private List<Double> response;
        private boolean hasIntercept = true;

        public Builder from(LinearRegression regression) {
            this.listBuilder = ImmutableList.builder();
            for (List<Double> predictor : regression.predictors()) {
                this.listBuilder.add((Object)ImmutableList.copyOf(predictor));
            }
            this.response = ImmutableList.copyOf(regression.response());
            this.hasIntercept = regression.hasIntercept();
            return this;
        }

        Builder predictors(List<List<Double>> predictors) {
            this.listBuilder = ImmutableList.builder();
            for (List<Double> predictor : predictors) {
                this.listBuilder.add((Object)ImmutableList.copyOf(predictor));
            }
            return this;
        }

        public Builder predictor(List<Double> predictor) {
            if (this.listBuilder == null) {
                this.listBuilder = ImmutableList.builder();
            }
            this.listBuilder.add((Object)ImmutableList.copyOf(predictor));
            return this;
        }

        public Builder response(List<Double> response) {
            this.response = ImmutableList.copyOf(response);
            return this;
        }

        public Builder hasIntercept(boolean hasIntercept) {
            this.hasIntercept = hasIntercept;
            return this;
        }

        public MultipleLinearRegression build() {
            return new MultipleLinearRegression(this);
        }
    }
}

