/*
 * Decompiled with CFR 0.152.
 */
package linear.regression.primitive;

import data.DoubleFunctions;
import java.util.Arrays;
import linear.regression.primitive.LinearRegression;
import org.ejml.alg.dense.mult.MatrixVectorMult;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.LinearSolverFactory;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.interfaces.linsol.LinearSolver;
import org.ejml.ops.CommonOps;
import stats.Statistics;

public final class MultipleLinearRegression
implements LinearRegression {
    private final double[][] predictors;
    private final double[] response;
    private final double[] beta;
    private final double[] standardErrors;
    private final double[] residuals;
    private final double[] fitted;
    private final boolean hasIntercept;
    private final double sigma2;

    private MultipleLinearRegression(Builder builder) {
        this.predictors = builder.predictors;
        this.response = builder.response;
        this.hasIntercept = builder.hasIntercept;
        MatrixFormulation matrixFormulation = new MatrixFormulation();
        this.beta = matrixFormulation.getBetaEstimates();
        this.standardErrors = matrixFormulation.getBetaStandardErrors(this.beta.length);
        this.fitted = matrixFormulation.computeFittedValues();
        this.residuals = matrixFormulation.getResiduals();
        this.sigma2 = matrixFormulation.getSigma2();
    }

    @Override
    public double[][] predictors() {
        return (double[][])this.predictors.clone();
    }

    @Override
    public double[] beta() {
        return this.beta;
    }

    @Override
    public double[] standardErrors() {
        return (double[])this.standardErrors.clone();
    }

    @Override
    public double sigma2() {
        return this.sigma2;
    }

    @Override
    public double[] response() {
        return (double[])this.response.clone();
    }

    @Override
    public double[] fitted() {
        return (double[])this.fitted.clone();
    }

    @Override
    public double[] residuals() {
        return (double[])this.residuals.clone();
    }

    @Override
    public boolean hasIntercept() {
        return this.hasIntercept;
    }

    public MultipleLinearRegression withHasIntercept(boolean hasIntercept) {
        return new Builder().from(this).hasIntercept(hasIntercept).build();
    }

    public MultipleLinearRegression withResponse(double[] response) {
        return new Builder().from(this).response(response).build();
    }

    public MultipleLinearRegression withPredictors(double ... predictors) {
        return new Builder().from(this).predictors(new double[][]{predictors}).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultipleLinearRegression)) {
            return false;
        }
        MultipleLinearRegression other = (MultipleLinearRegression)o;
        if (!Arrays.deepEquals((Object[])this.predictors, (Object[])other.predictors)) {
            return false;
        }
        if (!Arrays.equals(this.response, other.response)) {
            return false;
        }
        if (!Arrays.equals(this.beta, other.beta)) {
            return false;
        }
        if (!Arrays.equals(this.standardErrors, other.standardErrors)) {
            return false;
        }
        if (!Arrays.equals(this.residuals, other.residuals)) {
            return false;
        }
        if (!Arrays.equals(this.fitted, other.fitted)) {
            return false;
        }
        if (this.hasIntercept != other.hasIntercept) {
            return false;
        }
        return Double.compare(this.sigma2, other.sigma2) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode((Object[])this.predictors);
        result = result * 59 + Arrays.hashCode(this.response);
        result = result * 59 + Arrays.hashCode(this.beta);
        result = result * 59 + Arrays.hashCode(this.standardErrors);
        result = result * 59 + Arrays.hashCode(this.residuals);
        result = result * 59 + Arrays.hashCode(this.fitted);
        result = result * 59 + (this.hasIntercept ? 79 : 97);
        long $sigma2 = Double.doubleToLongBits(this.sigma2);
        result = result * 59 + (int)($sigma2 >>> 32 ^ $sigma2);
        return result;
    }

    public String toString() {
        return "MultipleLinearRegression(predictors=" + Arrays.deepToString((Object[])this.predictors) + ", response=" + Arrays.toString(this.response) + ", beta=" + Arrays.toString(this.beta) + ", standardErrors=" + Arrays.toString(this.standardErrors) + ", residuals=" + Arrays.toString(this.residuals) + ", fitted=" + Arrays.toString(this.fitted) + ", hasIntercept=" + this.hasIntercept + ", sigma2=" + this.sigma2 + ")";
    }

    private class MatrixFormulation {
        private final DenseMatrix64F A;
        private final DenseMatrix64F At;
        private final DenseMatrix64F AtAInv;
        private final DenseMatrix64F b;
        private final DenseMatrix64F y;
        private final double[] fitted;
        private final double[] residuals;
        private final double sigma2;
        private final DenseMatrix64F covarianceMatrix;

        MatrixFormulation() {
            int numRows = MultipleLinearRegression.this.response.length;
            int numCols = MultipleLinearRegression.this.predictors.length + (MultipleLinearRegression.this.hasIntercept ? 1 : 0);
            this.A = this.createMatrixA(numRows, numCols);
            this.At = new DenseMatrix64F(numCols, numRows);
            CommonOps.transpose((DenseMatrix64F)this.A, (DenseMatrix64F)this.At);
            this.AtAInv = new DenseMatrix64F(numCols, numCols);
            this.b = new DenseMatrix64F(numCols, 1);
            this.y = new DenseMatrix64F(numRows, 1);
            this.solveSystem(numRows, numCols);
            this.fitted = this.computeFittedValues();
            this.residuals = this.computeResiduals();
            this.sigma2 = this.estimateSigma2(numCols);
            this.covarianceMatrix = new DenseMatrix64F(numCols, numCols);
            CommonOps.scale((double)this.sigma2, (D1Matrix64F)this.AtAInv, (D1Matrix64F)this.covarianceMatrix);
        }

        private void solveSystem(int numRows, int numCols) {
            LinearSolver qrSolver = LinearSolverFactory.qr((int)numRows, (int)numCols);
            QRDecomposition decomposition = (QRDecomposition)qrSolver.getDecomposition();
            qrSolver.setA((Matrix)this.A);
            this.y.setData(MultipleLinearRegression.this.response);
            qrSolver.solve((Matrix)this.y, (Matrix)this.b);
            DenseMatrix64F R = (DenseMatrix64F)decomposition.getR(null, true);
            LinearSolver linearSolver = LinearSolverFactory.linear((int)numCols);
            linearSolver.setA((Matrix)R);
            DenseMatrix64F Rinverse = new DenseMatrix64F(numCols, numCols);
            linearSolver.invert((Matrix)Rinverse);
            CommonOps.multOuter((RowD1Matrix64F)Rinverse, (RowD1Matrix64F)this.AtAInv);
        }

        private DenseMatrix64F createMatrixA(int numRows, int numCols) {
            double[] data = MultipleLinearRegression.this.hasIntercept ? DoubleFunctions.fill(numRows, 1.0) : DoubleFunctions.arrayFrom(new double[0]);
            for (double[] predictor : MultipleLinearRegression.this.predictors) {
                data = DoubleFunctions.combine(data, DoubleFunctions.arrayFrom(predictor));
            }
            boolean isRowMajor = false;
            return new DenseMatrix64F(numRows, numCols, isRowMajor, data);
        }

        private double[] computeFittedValues() {
            DenseMatrix64F fitted = new DenseMatrix64F(MultipleLinearRegression.this.response.length, 1);
            MatrixVectorMult.mult((RowD1Matrix64F)this.A, (D1Matrix64F)this.b, (D1Matrix64F)fitted);
            return fitted.getData();
        }

        private double[] computeResiduals() {
            double[] resid = new double[this.fitted.length];
            for (int i = 0; i < resid.length; ++i) {
                resid[i] = MultipleLinearRegression.this.response[i] - this.fitted[i];
            }
            return resid;
        }

        private double[] getResiduals() {
            return (double[])this.residuals.clone();
        }

        private double estimateSigma2(int df) {
            double ssq = Statistics.sumOfSquared(DoubleFunctions.arrayFrom(this.residuals));
            return ssq / (double)(this.residuals.length - df);
        }

        private double[] getBetaStandardErrors(int numCols) {
            DenseMatrix64F diag = new DenseMatrix64F(numCols, 1);
            CommonOps.extractDiag((DenseMatrix64F)this.covarianceMatrix, (DenseMatrix64F)diag);
            return DoubleFunctions.sqrt(diag.getData());
        }

        private double[] getBetaEstimates() {
            return (double[])this.b.getData().clone();
        }

        private double getSigma2() {
            return this.sigma2;
        }
    }

    public static final class Builder {
        private double[][] predictors;
        private double[] response;
        private boolean hasIntercept = true;

        public final Builder from(LinearRegression regression) {
            this.predictors = (double[][])regression.predictors().clone();
            this.response = (double[])regression.response().clone();
            this.hasIntercept = regression.hasIntercept();
            return this;
        }

        public Builder predictors(double[] ... predictors) {
            this.predictors = new double[predictors.length][];
            for (int i = 0; i < predictors.length; ++i) {
                this.predictors[i] = (double[])predictors[i].clone();
            }
            return this;
        }

        public Builder response(double[] response) {
            this.response = (double[])response.clone();
            return this;
        }

        public Builder hasIntercept(boolean hasIntercept) {
            this.hasIntercept = hasIntercept;
            return this;
        }

        public MultipleLinearRegression build() {
            return new MultipleLinearRegression(this);
        }
    }
}

