/*
 * Decompiled with CFR 0.152.
 */
package math;

import lombok.NonNull;
import math.FieldElement;
import math.Real;

public final class Complex
implements FieldElement<Complex> {
    private static final double EPSILON = Math.ulp(1.0);
    private final double real;
    private final double im;

    public Complex() {
        this(0.0, 0.0);
    }

    public Complex(double real) {
        this(real, 0.0);
    }

    public Complex(double real, double im) {
        this.real = real;
        this.im = im;
    }

    public static Complex from(Real real) {
        return new Complex(real.asDouble());
    }

    public static Complex zero() {
        return new Complex(0.0, 0.0);
    }

    @Override
    public final Complex plus(Complex other) {
        return new Complex(this.real + other.real, this.im + other.im);
    }

    @Override
    public final Complex plus(double other) {
        return new Complex(this.real + other, this.im);
    }

    @Override
    public final Complex minus(Complex other) {
        return new Complex(this.real - other.real, this.im - other.im);
    }

    @Override
    public final Complex times(Complex other) {
        double realPart = this.real * other.real - this.im * other.im;
        double imPart = this.real * other.im + other.real * this.im;
        return new Complex(realPart, imPart);
    }

    @Override
    public Complex times(double other) {
        return new Complex(this.real * other, this.im * other);
    }

    @Override
    public final Complex dividedBy(double value) {
        if (value == 0.0) {
            throw new IllegalArgumentException("Attempt to divide a complex number by zero.");
        }
        return new Complex(this.real / value, this.im / value);
    }

    @Override
    public final Complex dividedBy(Complex value) {
        Complex top = new Complex(this.real * value.real + this.im * value.im, this.real * -value.im + value.real * this.im);
        double bottom = value.real * value.real + value.im * value.im;
        return top.dividedBy(bottom);
    }

    @Override
    public final Complex dividedBy(int value) {
        return this.dividedBy((double)value);
    }

    @Override
    public final Complex conjugate() {
        return new Complex(this.real, -this.im);
    }

    @Override
    public final double abs() {
        return Math.sqrt(this.real * this.real + this.im * this.im);
    }

    @Override
    public Complex additiveInverse() {
        return new Complex(-this.real, -this.im);
    }

    @Override
    public Complex sqrt() {
        if (this.real < EPSILON && Math.abs(this.im) < EPSILON) {
            return new Complex(0.0, Math.sqrt(this.abs()));
        }
        double r = this.abs();
        Complex zr = this.plus(r);
        return zr.dividedBy(zr.abs()).times(Math.sqrt(r));
    }

    public final double doubleValue() {
        return this.real;
    }

    public final double im() {
        return this.im;
    }

    public final boolean isReal() {
        return Math.abs(this.im) < EPSILON;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Complex: ");
        if (!(Math.abs(this.real) > 0.0)) {
            if (Math.abs(this.im) > 0.0) {
                return sb.append(this.im).append("i").toString();
            }
            return sb.append("0.0").toString();
        }
        sb.append(Double.toString(this.real));
        if (this.im < 0.0) {
            sb.append(" - ").append(Math.abs(this.im)).append("i");
        } else if (this.im > 0.0) {
            sb.append(" + ").append(this.im).append("i");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(@NonNull Complex other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        return Double.compare(this.abs(), other.abs());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Complex)) {
            return false;
        }
        Complex other = (Complex)o;
        if (Double.compare(this.real, other.real) != 0) {
            return false;
        }
        return Double.compare(this.im, other.im) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $real = Double.doubleToLongBits(this.real);
        result = result * 59 + (int)($real >>> 32 ^ $real);
        long $im = Double.doubleToLongBits(this.im);
        result = result * 59 + (int)($im >>> 32 ^ $im);
        return result;
    }
}

