/*
 * Decompiled with CFR 0.152.
 */
package math.function;

import linear.doubles.Vector;
import math.function.MultivariateFunction;
import optim.NumericalDerivatives;

public abstract class AbstractMultivariateFunction
implements MultivariateFunction {
    private static final double gradientTolerance = 0.001;
    protected int functionEvaluations = 0;
    protected int gradientEvalutations = 0;

    public Vector gradientAt(Vector point) {
        ++this.gradientEvalutations;
        return NumericalDerivatives.centralDifferenceGradient(this, point, 0.001);
    }

    public Vector gradientAt(Vector point, double functionValue) {
        ++this.gradientEvalutations;
        return NumericalDerivatives.forwardDifferenceGradient(this, point, 1.0E-6, functionValue);
    }

    public int functionEvaluations() {
        return this.functionEvaluations;
    }

    public int gradientEvaluations() {
        return this.gradientEvalutations;
    }
}

