/*
 * Decompiled with CFR 0.152.
 */
package timeseries;

import timeseries.TimeUnit;

public final class TimePeriod {
    private final TimeUnit timeUnit;
    private final long periodLength;

    public TimePeriod(TimeUnit timeUnit, long periodLength) {
        this.validate(periodLength);
        this.timeUnit = timeUnit;
        this.periodLength = periodLength;
    }

    public static TimePeriod oneHour() {
        return new TimePeriod(TimeUnit.HOUR, 1L);
    }

    public static TimePeriod oneYear() {
        return new TimePeriod(TimeUnit.YEAR, 1L);
    }

    public static TimePeriod twoYears() {
        return new TimePeriod(TimeUnit.YEAR, 2L);
    }

    public static TimePeriod halfDecade() {
        return new TimePeriod(TimeUnit.YEAR, 5L);
    }

    public static TimePeriod oneMonth() {
        return new TimePeriod(TimeUnit.MONTH, 1L);
    }

    public static TimePeriod halfMonth() {
        int secondsInHalfMonth = 1314873;
        return new TimePeriod(TimeUnit.SECOND, 1314873L);
    }

    public static TimePeriod oneQuarter() {
        return new TimePeriod(TimeUnit.QUARTER, 1L);
    }

    public static TimePeriod oneWeek() {
        return new TimePeriod(TimeUnit.WEEK, 1L);
    }

    public static TimePeriod oneDay() {
        return new TimePeriod(TimeUnit.DAY, 1L);
    }

    public static TimePeriod halfYear() {
        return new TimePeriod(TimeUnit.MONTH, 6L);
    }

    public static TimePeriod oneDecade() {
        return new TimePeriod(TimeUnit.DECADE, 1L);
    }

    public static TimePeriod halfCentury() {
        return new TimePeriod(TimeUnit.DECADE, 5L);
    }

    public static TimePeriod oneCentury() {
        return new TimePeriod(TimeUnit.CENTURY, 1L);
    }

    public static TimePeriod halfHour() {
        return new TimePeriod(TimeUnit.MINUTE, 30L);
    }

    public static TimePeriod halfDay() {
        return new TimePeriod(TimeUnit.HOUR, 12L);
    }

    public static TimePeriod triAnnual() {
        return new TimePeriod(TimeUnit.MONTH, 4L);
    }

    public static TimePeriod oneSecond() {
        return new TimePeriod(TimeUnit.SECOND, 1L);
    }

    public static TimePeriod halfSecond() {
        return new TimePeriod(TimeUnit.MILLISECOND, 500L);
    }

    public static TimePeriod oneTenthSecond() {
        return new TimePeriod(TimeUnit.MILLISECOND, 100L);
    }

    public TimeUnit timeUnit() {
        return this.timeUnit;
    }

    public long periodLength() {
        return this.periodLength;
    }

    public double frequencyPer(TimePeriod otherTimePeriod) {
        return otherTimePeriod.totalSeconds() / this.totalSeconds();
    }

    public double totalSeconds() {
        double thisDuration = this.timeUnit.totalDuration();
        return thisDuration * (double)this.periodLength;
    }

    private void validate(long unitLength) {
        if (unitLength <= 0L) {
            throw new IllegalArgumentException("The provided unitLength must be a positive integer");
        }
    }

    public String toString() {
        return "timeUnit: " + (Object)((Object)this.timeUnit) + "\nperiodLength: " + this.periodLength;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.timeUnit == null ? 0 : this.timeUnit.hashCode());
        long temp = Double.doubleToLongBits(this.periodLength);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimePeriod other = (TimePeriod)obj;
        return this.timeUnit == other.timeUnit && Double.doubleToLongBits(this.periodLength) == Double.doubleToLongBits(other.periodLength);
    }
}

