/*
 * Decompiled with CFR 0.152.
 */
package timeseries;

import data.DataSet;
import data.DoubleDataSet;
import data.DoubleFunctions;
import data.Plots;
import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import org.knowm.xchart.XChartPanel;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.lines.SeriesLines;
import org.knowm.xchart.style.markers.SeriesMarkers;
import timeseries.TimePeriod;
import timeseries.TimeUnit;

public final class TimeSeries
implements DataSet {
    private final TimePeriod timePeriod;
    private final int n;
    private final double mean;
    private final double[] series;
    private final List<OffsetDateTime> observationTimes;
    private final Map<OffsetDateTime, Integer> dateTimeIndex;
    private final DoubleDataSet dataSet;

    public TimeSeries(double ... series) {
        this(OffsetDateTime.of(1, 1, 1, 0, 0, 0, 0, ZoneOffset.ofHours(0)), series);
    }

    public TimeSeries(TimeUnit timeUnit, OffsetDateTime startTime, double ... series) {
        this(new TimePeriod(timeUnit, 1L), startTime, series);
    }

    public TimeSeries(TimePeriod timePeriod, String startTime, double ... series) {
        OffsetDateTime dateTime;
        this.dataSet = new DoubleDataSet(series);
        this.series = (double[])series.clone();
        this.n = series.length;
        this.mean = this.dataSet.mean();
        this.timePeriod = timePeriod;
        HashMap<OffsetDateTime, Integer> dateTimeIndex = new HashMap<OffsetDateTime, Integer>(series.length);
        ArrayList<OffsetDateTime> dateTimes = new ArrayList<OffsetDateTime>(series.length);
        try {
            dateTime = OffsetDateTime.parse(startTime);
            dateTimes.add(dateTime);
            dateTimeIndex.put(dateTime, 0);
        }
        catch (DateTimeParseException e) {
            dateTime = OffsetDateTime.of(LocalDateTime.parse(startTime), ZoneOffset.ofHours(0));
            dateTimes.add(dateTime);
            dateTimeIndex.put(dateTime, 0);
        }
        for (int i = 1; i < series.length; ++i) {
            dateTime = ((OffsetDateTime)dateTimes.get(i - 1)).plus(this.totalPeriodLength(timePeriod), timePeriod.timeUnit().temporalUnit());
            dateTimes.add(dateTime);
            dateTimeIndex.put(dateTime, i);
        }
        this.observationTimes = Collections.unmodifiableList(dateTimes);
        this.dateTimeIndex = Collections.unmodifiableMap(dateTimeIndex);
    }

    public TimeSeries(TimePeriod timePeriod, OffsetDateTime startTime, double ... series) {
        this.dataSet = new DoubleDataSet(series);
        this.series = (double[])series.clone();
        this.n = series.length;
        this.mean = this.dataSet.mean();
        this.timePeriod = timePeriod;
        ArrayList<OffsetDateTime> dateTimes = new ArrayList<OffsetDateTime>(series.length);
        HashMap<OffsetDateTime, Integer> dateTimeIndex = new HashMap<OffsetDateTime, Integer>(series.length);
        dateTimes.add(startTime);
        dateTimeIndex.put(startTime, 0);
        for (int i = 1; i < series.length; ++i) {
            OffsetDateTime dateTime = ((OffsetDateTime)dateTimes.get(i - 1)).plus(timePeriod.periodLength() * timePeriod.timeUnit().unitLength(), timePeriod.timeUnit().temporalUnit());
            dateTimes.add(dateTime);
            dateTimeIndex.put(dateTime, i);
        }
        this.observationTimes = Collections.unmodifiableList(dateTimes);
        this.dateTimeIndex = Collections.unmodifiableMap(dateTimeIndex);
    }

    public TimeSeries(TimeUnit timeUnit, String startTime, double ... series) {
        this(new TimePeriod(timeUnit, 1L), startTime, series);
    }

    TimeSeries(OffsetDateTime startTime, double ... series) {
        this(TimeUnit.MONTH, startTime, series);
    }

    public TimeSeries(TimePeriod timePeriod, List<OffsetDateTime> observationTimes, double ... series) {
        this.dataSet = new DoubleDataSet(series);
        this.series = (double[])series.clone();
        this.n = series.length;
        this.mean = this.dataSet.mean();
        this.timePeriod = timePeriod;
        this.observationTimes = Collections.unmodifiableList(observationTimes);
        HashMap<OffsetDateTime, Integer> dateTimeIndex = new HashMap<OffsetDateTime, Integer>(series.length);
        int i = 0;
        for (OffsetDateTime dt : observationTimes) {
            dateTimeIndex.put(dt, i++);
        }
        this.dateTimeIndex = Collections.unmodifiableMap(dateTimeIndex);
    }

    public final TimeSeries aggregateToYears() {
        return this.aggregate(TimePeriod.oneYear());
    }

    public final TimeSeries aggregate(TimeUnit timeUnit) {
        return this.aggregate(new TimePeriod(timeUnit, 1L));
    }

    public final TimeSeries aggregate(TimePeriod timePeriod) {
        int period = (int)this.timePeriod.frequencyPer(timePeriod);
        if (period == 0) {
            throw new IllegalArgumentException("The given time period was of a smaller magnitude than the original time period. To aggregate a series, the time period argument must be of a larger magnitude than the original.");
        }
        ArrayList<OffsetDateTime> obsTimes = new ArrayList<OffsetDateTime>();
        double[] aggregated = new double[this.series.length / period];
        for (int i = 0; i < aggregated.length; ++i) {
            double sum = 0.0;
            for (int j = 0; j < period; ++j) {
                sum += this.series[j + period * i];
            }
            aggregated[i] = sum;
            obsTimes.add(this.observationTimes.get(i * period));
        }
        return new TimeSeries(timePeriod, obsTimes, aggregated);
    }

    public final double at(int index) {
        return this.series[index];
    }

    public final double at(OffsetDateTime dateTime) {
        return this.series[this.dateTimeIndex.get(dateTime)];
    }

    public final double autoCorrelationAtLag(int k) {
        double variance = this.autoCovarianceAtLag(0);
        return this.autoCovarianceAtLag(k) / variance;
    }

    public final double[] autoCorrelationUpToLag(int k) {
        double[] autoCorrelation = new double[Math.min(k + 1, this.n)];
        for (int i = 0; i < Math.min(k + 1, this.n); ++i) {
            autoCorrelation[i] = this.autoCorrelationAtLag(i);
        }
        return autoCorrelation;
    }

    public final double autoCovarianceAtLag(int k) {
        if (k < 0) {
            throw new IllegalArgumentException("The lag, k, must be non-negative, but was " + k);
        }
        double sumOfProductOfDeviations = 0.0;
        for (int t = 0; t < this.n - k; ++t) {
            sumOfProductOfDeviations += (this.series[t] - this.mean) * (this.series[t + k] - this.mean);
        }
        return sumOfProductOfDeviations / (double)this.n;
    }

    public final double[] autoCovarianceUpToLag(int k) {
        double[] acv = new double[Math.min(k + 1, this.n)];
        for (int i = 0; i < Math.min(k + 1, this.n); ++i) {
            acv[i] = this.autoCovarianceAtLag(i);
        }
        return acv;
    }

    public final TimeSeries transform(double boxCoxLambda) {
        if (boxCoxLambda > 2.0 || boxCoxLambda < -1.0) {
            throw new IllegalArgumentException("The BoxCox parameter must lie between -1 and 2, but the provided parameter was equal to " + boxCoxLambda);
        }
        double[] boxCoxed = DoubleFunctions.boxCox(this.series, boxCoxLambda);
        return new TimeSeries(this.timePeriod, this.observationTimes, boxCoxed);
    }

    public final TimeSeries backTransform(double boxCoxLambda) {
        if (boxCoxLambda > 2.0 || boxCoxLambda < -1.0) {
            throw new IllegalArgumentException("The BoxCox parameter must lie between -1 and 2, but the provided parameter was equal to " + boxCoxLambda);
        }
        double[] invBoxCoxed = DoubleFunctions.inverseBoxCox(this.series, boxCoxLambda);
        return new TimeSeries(this.timePeriod, this.observationTimes, invBoxCoxed);
    }

    public final TimeSeries movingAverage(int m) {
        int c = m % 2;
        int k = (m - c) / 2;
        double[] average = new double[this.n - m + 1];
        for (int t = 0; t < average.length; ++t) {
            double sum = 0.0;
            for (int j = -k; j < k + c; ++j) {
                sum += this.series[t + k + j];
            }
            average[t] = sum / (double)m;
        }
        List<OffsetDateTime> times = this.observationTimes.subList(k + c - 1, this.n - k);
        return new TimeSeries(this.timePeriod, times, average);
    }

    public final TimeSeries centeredMovingAverage(int m) {
        if (m % 2 == 1) {
            return this.movingAverage(m);
        }
        TimeSeries firstAverage = this.movingAverage(m);
        int k = m / 2;
        List<OffsetDateTime> times = this.observationTimes.subList(k, this.n - k);
        return new TimeSeries(this.timePeriod, times, firstAverage.movingAverage((int)2).series);
    }

    public final TimeSeries demean() {
        double[] demeaned = new double[this.series.length];
        for (int t = 0; t < demeaned.length; ++t) {
            demeaned[t] = this.series[t] - this.mean;
        }
        return new TimeSeries(this.timePeriod, this.observationTimes, demeaned);
    }

    public final TimeSeries difference(int lag, int times) {
        if (times > 0) {
            TimeSeries diffed = this.difference(lag);
            for (int i = 1; i < times; ++i) {
                diffed = diffed.difference(lag);
            }
            return diffed;
        }
        return this;
    }

    public final TimeSeries difference(int lag) {
        double[] diffed = this.differenceArray(lag);
        List<OffsetDateTime> obsTimes = this.observationTimes.subList(lag, this.n);
        return new TimeSeries(this.timePeriod, obsTimes, diffed);
    }

    public final TimeSeries difference() {
        return this.difference(1);
    }

    private double[] differenceArray(int lag) {
        double[] differenced = new double[this.series.length - lag];
        for (int i = 0; i < differenced.length; ++i) {
            differenced[i] = this.series[i + lag] - this.series[i];
        }
        return differenced;
    }

    public final TimeSeries minus(TimeSeries otherSeries) {
        double[] subtracted = new double[this.series.length];
        for (int t = 0; t < subtracted.length; ++t) {
            subtracted[t] = this.series[t] - otherSeries.series[t];
        }
        return new TimeSeries(this.timePeriod, this.observationTimes, subtracted);
    }

    public final TimeSeries from(int start, int end) {
        double[] sliced = new double[end - start + 1];
        System.arraycopy(this.series, start, sliced, 0, end - start + 1);
        List<OffsetDateTime> obsTimes = this.observationTimes.subList(start, end + 1);
        return new TimeSeries(this.timePeriod, obsTimes, sliced);
    }

    public final TimeSeries from(OffsetDateTime start, OffsetDateTime end) {
        int startIdx = this.dateTimeIndex.get(start);
        int endIdx = this.dateTimeIndex.get(end);
        double[] sliced = new double[endIdx - startIdx + 1];
        System.arraycopy(this.series, startIdx, sliced, 0, endIdx - startIdx + 1);
        List<OffsetDateTime> obsTimes = this.observationTimes.subList(startIdx, endIdx + 1);
        return new TimeSeries(this.timePeriod, obsTimes, sliced);
    }

    public final TimeSeries timeSlice(int start, int end) {
        double[] sliced = new double[end - start + 1];
        System.arraycopy(this.series, start - 1, sliced, 0, end - start + 1);
        List<OffsetDateTime> obsTimes = this.observationTimes.subList(start - 1, end);
        return new TimeSeries(this.timePeriod, obsTimes, sliced);
    }

    private long totalPeriodLength(TimePeriod timePeriod) {
        return timePeriod.timeUnit().unitLength() * timePeriod.periodLength();
    }

    public final void print() {
        System.out.println(this.toString());
    }

    public final List<Double> asList() {
        return DoubleFunctions.listFrom((double[])this.series.clone());
    }

    public final TimePeriod timePeriod() {
        return this.timePeriod;
    }

    public final OffsetDateTime startTime() {
        return this.observationTimes.get(0);
    }

    public final List<OffsetDateTime> observationTimes() {
        return this.observationTimes;
    }

    public final Map<OffsetDateTime, Integer> dateTimeIndex() {
        return this.dateTimeIndex;
    }

    @Override
    public final double[] asArray() {
        return (double[])this.series.clone();
    }

    @Override
    public double sum() {
        return this.dataSet.sum();
    }

    @Override
    public double sumOfSquares() {
        return this.dataSet.sumOfSquares();
    }

    @Override
    public double mean() {
        return this.dataSet.mean();
    }

    @Override
    public double median() {
        return this.dataSet.median();
    }

    @Override
    public int n() {
        return this.dataSet.n();
    }

    @Override
    public DataSet times(DataSet otherData) {
        return this.dataSet.times(otherData);
    }

    @Override
    public DataSet plus(DataSet otherData) {
        return this.dataSet.plus(otherData);
    }

    @Override
    public double variance() {
        return this.dataSet.variance();
    }

    @Override
    public double stdDeviation() {
        return this.dataSet.stdDeviation();
    }

    @Override
    public double covariance(DataSet otherData) {
        return this.dataSet.covariance(otherData);
    }

    @Override
    public double correlation(DataSet otherData) {
        return this.dataSet.correlation(otherData);
    }

    @Override
    public final void plot() {
        Plots.plot(this, "Time Series Values", "series");
    }

    @Override
    public void plotAgainst(DataSet otherData) {
        this.dataSet.plotAgainst(otherData);
    }

    public final void plotAcf(int k) {
        int i;
        double[] acf = this.autoCorrelationUpToLag(k);
        double[] lags = new double[k + 1];
        for (int i2 = 1; i2 < lags.length; ++i2) {
            lags[i2] = i2;
        }
        double upper = (double)(-1 / this.series.length) + 2.0 / Math.sqrt(this.series.length);
        double lower = (double)(-1 / this.series.length) - 2.0 / Math.sqrt(this.series.length);
        double[] upperLine = new double[lags.length];
        double[] lowerLine = new double[lags.length];
        for (i = 0; i < lags.length; ++i) {
            upperLine[i] = upper;
        }
        for (i = 0; i < lags.length; ++i) {
            lowerLine[i] = lower;
        }
        new Thread(() -> {
            XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().theme(Styler.ChartTheme.GGPlot2)).height(800)).width(1200)).title("Autocorrelations By Lag")).build();
            XYSeries series = chart.addSeries("Autocorrelation", lags, acf);
            XYSeries series2 = chart.addSeries("Upper Bound", lags, upperLine);
            XYSeries series3 = chart.addSeries("Lower Bound", lags, lowerLine);
            ((XYStyler)chart.getStyler()).setChartFontColor(Color.BLACK).setSeriesColors(new Color[]{Color.BLACK, Color.BLUE, Color.BLUE});
            series.setXYSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter);
            series2.setXYSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Line).setMarker(SeriesMarkers.NONE).setLineStyle(SeriesLines.DASH_DASH);
            series3.setXYSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Line).setMarker(SeriesMarkers.NONE).setLineStyle(SeriesLines.DASH_DASH);
            XChartPanel panel = new XChartPanel((Chart)chart);
            JFrame frame = new JFrame("Autocorrelation by Lag");
            frame.setDefaultCloseOperation(2);
            frame.add((Component)panel);
            frame.pack();
            frame.setVisible(true);
        }).run();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeSeries that = (TimeSeries)o;
        if (this.n != that.n) {
            return false;
        }
        if (this.timePeriod != null ? !this.timePeriod.equals(that.timePeriod) : that.timePeriod != null) {
            return false;
        }
        if (!Arrays.equals(this.series, that.series)) {
            return false;
        }
        return this.observationTimes.equals(that.observationTimes);
    }

    public int hashCode() {
        int result = this.timePeriod != null ? this.timePeriod.hashCode() : 0;
        result = 31 * result + this.n;
        result = 31 * result + Arrays.hashCode(this.series);
        result = 31 * result + this.observationTimes.hashCode();
        return result;
    }

    public String toString() {
        DecimalFormat numFormatter = new DecimalFormat("#0.0000");
        StringBuilder builder = new StringBuilder();
        builder.append("n: ").append(this.n).append("\nmean: ").append(numFormatter.format(this.mean)).append("\nseries: ");
        if (this.series.length > 6) {
            for (double d : DoubleFunctions.slice(this.series, 0, 3)) {
                builder.append(numFormatter.format(d)).append(", ");
            }
            builder.append("..., ");
            for (double d : DoubleFunctions.slice(this.series, this.n - 3, this.n - 1)) {
                builder.append(numFormatter.format(d)).append(", ");
            }
            builder.append(numFormatter.format(this.series[this.n - 1]));
        } else {
            for (int i = 0; i < this.series.length - 1; ++i) {
                builder.append(numFormatter.format(this.series[i])).append(", ");
            }
            builder.append(numFormatter.format(this.series[this.n - 1]));
        }
        builder.append("\nobservationTimes: ");
        if (this.series.length > 6) {
            for (OffsetDateTime date : this.observationTimes.subList(0, 3)) {
                builder.append(date.toString()).append(", ");
            }
            builder.append("..., ");
            for (OffsetDateTime date : this.observationTimes.subList(this.n - 3, this.n - 1)) {
                builder.append(date.toString()).append(", ");
            }
            builder.append(this.observationTimes.get(this.n - 1).toString());
        } else {
            for (int i = 0; i < this.observationTimes.size() - 1; ++i) {
                builder.append(this.observationTimes.get(i).toString()).append(", ");
            }
            builder.append(this.observationTimes.get(this.n - 1).toString());
        }
        return builder.append("\ntimePeriod: \n").append(this.timePeriod).toString();
    }
}

