/*
 * Decompiled with CFR 0.152.
 */
package timeseries;

import java.time.LocalDateTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import timeseries.TimePeriod;
import timeseries.TimeSeries;
import timeseries.TimeUnit;

public final class Ts {
    private static final int ZONE_OFFSET = 0;

    private Ts() {
    }

    public static TimeSeries newAnnualSeries(int startYear, double ... series) {
        LocalDateTime localDateTime = LocalDateTime.of(startYear, Month.JANUARY, 1, 0, 0);
        OffsetDateTime startingInstant = OffsetDateTime.of(localDateTime, ZoneOffset.ofHours(0));
        return new TimeSeries(TimePeriod.oneYear(), startingInstant, series);
    }

    public static TimeSeries newMonthlySeries(int startYear, int startMonth, double ... series) {
        return Ts.newMonthlySeries(startYear, startMonth, 1, series);
    }

    public static TimeSeries newMonthlySeries(int startYear, int startMonth, int startDay, double ... series) {
        OffsetDateTime startingInstant = OffsetDateTime.of(startYear, startMonth, startDay, 0, 0, 0, 0, ZoneOffset.ofHours(0));
        TimeUnit timeUnit = TimeUnit.MONTH;
        boolean periodLength = true;
        return new TimeSeries(new TimePeriod(timeUnit, 1L), startingInstant, series);
    }

    public static TimeSeries newQuarterlySeries(int startYear, int startQuarter, double ... series) {
        int startMonth = 3 * startQuarter - 2;
        OffsetDateTime startingInstant = OffsetDateTime.of(startYear, startMonth, 1, 0, 0, 0, 0, ZoneOffset.ofHours(0));
        TimeUnit timeUnit = TimeUnit.QUARTER;
        boolean periodLength = true;
        return new TimeSeries(new TimePeriod(timeUnit, 1L), startingInstant, series);
    }
}

