/*
 * Decompiled with CFR 0.152.
 */
package timeseries.models;

import com.google.common.primitives.Doubles;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JFrame;
import org.knowm.xchart.XChartPanel;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.markers.Circle;
import org.knowm.xchart.style.markers.Marker;
import org.knowm.xchart.style.markers.None;
import stats.distributions.StudentsT;
import timeseries.TimeSeries;
import timeseries.models.Forecast;
import timeseries.models.Model;

public final class MeanForecast
implements Forecast {
    private final Model model;
    private final TimeSeries forecast;
    private final TimeSeries upperValues;
    private final TimeSeries lowerValues;
    private final TimeSeries fcstErrors;

    public MeanForecast(Model model, int steps, double alpha) {
        if (steps < 1) {
            throw new IllegalArgumentException("The number of steps ahead to forecast must be greater than or equal to 1, but was " + steps);
        }
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("The value of alpha must be between 0 and 1, but was " + alpha);
        }
        this.model = model;
        this.forecast = model.pointForecast(steps);
        this.fcstErrors = this.getFcstErrors(steps, alpha);
        this.upperValues = this.computeUpperPredictionBounds();
        this.lowerValues = this.computeLowerPredictionBounds();
    }

    public MeanForecast(Model model) {
        this(model, 12, 0.05);
    }

    @Override
    public TimeSeries forecast() {
        return this.forecast;
    }

    @Override
    public TimeSeries upperPredictionValues() {
        return this.upperValues;
    }

    @Override
    public TimeSeries lowerPredictionValues() {
        return this.lowerValues;
    }

    @Override
    public TimeSeries computeUpperPredictionBounds(int steps, double alpha) {
        if (steps < 1) {
            throw new IllegalArgumentException("The number of steps ahead to forecast must be greater than or equal to 1, but was " + steps);
        }
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("The value of alpha must be between 0 and 1, but was " + alpha);
        }
        TimeSeries forecast = this.model.pointForecast(steps);
        TimeSeries fcstStdError = this.getFcstErrors(steps, alpha);
        double[] upperPredictionValues = new double[steps];
        for (int t = 0; t < steps; ++t) {
            upperPredictionValues[t] = forecast.at(t) + fcstStdError.at(t);
        }
        return new TimeSeries(forecast.timePeriod(), forecast.observationTimes().get(0), upperPredictionValues);
    }

    @Override
    public TimeSeries computeLowerPredictionBounds(int steps, double alpha) {
        if (steps < 1) {
            throw new IllegalArgumentException("The number of steps ahead to forecast must be greater than or equal to 1, but was " + steps);
        }
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("The value of alpha must be between 0 and 1, but was " + alpha);
        }
        TimeSeries forecast = this.model.pointForecast(steps);
        double[] lowerPredictionValues = new double[steps];
        TimeSeries fcstStdError = this.getFcstErrors(steps, alpha);
        for (int t = 0; t < steps; ++t) {
            lowerPredictionValues[t] = forecast.at(t) - fcstStdError.at(t);
        }
        return new TimeSeries(forecast.timePeriod(), forecast.observationTimes().get(0), lowerPredictionValues);
    }

    @Override
    public void plotForecast() {
        new Thread(() -> {
            ArrayList<Date> xAxis = new ArrayList<Date>(this.forecast.observationTimes().size());
            for (OffsetDateTime dateTime : this.forecast.observationTimes()) {
                xAxis.add(Date.from(dateTime.toInstant()));
            }
            List errorList = Doubles.asList((double[])this.fcstErrors.asArray());
            List forecastList = Doubles.asList((double[])this.forecast.asArray());
            XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().theme(Styler.ChartTheme.GGPlot2)).height(600)).width(800)).title("Mean Forecast")).build();
            chart.setXAxisTitle("Time");
            chart.setYAxisTitle("Forecast Values");
            ((XYStyler)chart.getStyler()).setAxisTitleFont(new Font("Arial", 0, 14)).setMarkerSize(5);
            ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Line).setErrorBarsColor(Color.RED).setChartFontColor(new Color(112, 112, 112));
            XYSeries forecastSeries = chart.addSeries("Forecast", xAxis, forecastList, errorList);
            forecastSeries.setMarker((Marker)new Circle()).setMarkerColor(Color.BLACK).setLineWidth(1.5f).setLineColor(Color.BLUE);
            XChartPanel panel = new XChartPanel((Chart)chart);
            JFrame frame = new JFrame("Mean Forecast");
            frame.setDefaultCloseOperation(2);
            frame.add((Component)panel);
            frame.pack();
            frame.setVisible(true);
        }).start();
    }

    @Override
    public void plot() {
        new Thread(() -> {
            ArrayList<Date> xAxis = new ArrayList<Date>(this.forecast.observationTimes().size());
            ArrayList<Date> xAxisObs = new ArrayList<Date>(this.model.timeSeries().n());
            for (OffsetDateTime dateTime : this.model.timeSeries().observationTimes()) {
                xAxisObs.add(Date.from(dateTime.toInstant()));
            }
            for (OffsetDateTime dateTime : this.forecast.observationTimes()) {
                xAxis.add(Date.from(dateTime.toInstant()));
            }
            List errorList = Doubles.asList((double[])this.fcstErrors.asArray());
            List seriesList = Doubles.asList((double[])this.model.timeSeries().asArray());
            List forecastList = Doubles.asList((double[])this.forecast.asArray());
            XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().theme(Styler.ChartTheme.GGPlot2)).height(800)).width(1200)).title("Mean Forecast Past and Future")).build();
            XYSeries observationSeries = chart.addSeries("Past", xAxisObs, seriesList);
            XYSeries forecastSeries = chart.addSeries("Future", xAxis, forecastList, errorList);
            observationSeries.setMarker((Marker)new None());
            forecastSeries.setMarker((Marker)new None());
            observationSeries.setLineWidth(0.75f);
            forecastSeries.setLineWidth(1.5f);
            ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Line).setErrorBarsColor(Color.RED);
            observationSeries.setLineColor(Color.BLACK);
            forecastSeries.setLineColor(Color.BLUE);
            XChartPanel panel = new XChartPanel((Chart)chart);
            JFrame frame = new JFrame("Mean Forecast Past and Future");
            frame.setDefaultCloseOperation(2);
            frame.add((Component)panel);
            frame.pack();
            frame.setVisible(true);
        }).start();
    }

    private TimeSeries computeUpperPredictionBounds() {
        double[] upperPredictionValues = new double[this.forecast.n()];
        for (int t = 0; t < this.forecast.n(); ++t) {
            upperPredictionValues[t] = this.forecast.at(t) + this.fcstErrors.at(t);
        }
        return new TimeSeries(this.forecast.timePeriod(), this.forecast.observationTimes().get(0), upperPredictionValues);
    }

    private TimeSeries computeLowerPredictionBounds() {
        double[] lowerPredictionValues = new double[this.forecast.n()];
        for (int t = 0; t < this.forecast.n(); ++t) {
            lowerPredictionValues[t] = this.forecast.at(t) - this.fcstErrors.at(t);
        }
        return new TimeSeries(this.forecast.timePeriod(), this.forecast.observationTimes().get(0), lowerPredictionValues);
    }

    private TimeSeries getFcstErrors(int steps, double alpha) {
        double[] errors = new double[steps];
        double criticalValue = new StudentsT(this.model.timeSeries().n() - 1).quantile(1.0 - alpha / 2.0);
        double variance = this.model.timeSeries().variance();
        double meanStdError = variance / (double)this.model.timeSeries().n();
        double fcstStdError = Math.sqrt(variance + meanStdError);
        for (int t = 0; t < errors.length; ++t) {
            errors[t] = criticalValue * fcstStdError;
        }
        return new TimeSeries(this.forecast.timePeriod(), this.forecast.observationTimes().get(0), errors);
    }
}

