/*
 * Decompiled with CFR 0.152.
 */
package timeseries.models;

import data.DoubleFunctions;
import java.time.OffsetDateTime;
import timeseries.TimePeriod;
import timeseries.TimeSeries;
import timeseries.models.Forecast;
import timeseries.models.MeanForecast;
import timeseries.models.Model;

public final class MeanModel
implements Model {
    private final TimeSeries timeSeries;
    private final TimeSeries fittedSeries;
    private final double mean;

    public MeanModel(TimeSeries observed) {
        this.timeSeries = observed;
        this.mean = this.timeSeries.mean();
        this.fittedSeries = new TimeSeries(observed.timePeriod(), observed.observationTimes().get(0), DoubleFunctions.fill(observed.n(), this.mean));
    }

    @Override
    public Forecast forecast(int steps, double alpha) {
        return new MeanForecast(this, steps, alpha);
    }

    @Override
    public TimeSeries pointForecast(int steps) {
        int n = this.timeSeries.n();
        TimePeriod timePeriod = this.timeSeries.timePeriod();
        double[] forecasted = DoubleFunctions.fill(steps, this.mean);
        OffsetDateTime startTime = this.timeSeries.observationTimes().get(n - 1).plus(timePeriod.periodLength() * timePeriod.timeUnit().unitLength(), timePeriod.timeUnit().temporalUnit());
        return new TimeSeries(timePeriod, startTime, forecasted);
    }

    @Override
    public TimeSeries timeSeries() {
        return this.timeSeries;
    }

    @Override
    public TimeSeries fittedSeries() {
        return this.fittedSeries;
    }

    @Override
    public TimeSeries residuals() {
        return this.timeSeries.minus(this.fittedSeries);
    }

    public String toString() {
        return "timeSeries: " + this.timeSeries + "\nfittedSeries: " + this.fittedSeries + "\nmean: " + this.mean;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeanModel meanModel = (MeanModel)o;
        if (Double.compare(meanModel.mean, this.mean) != 0) {
            return false;
        }
        if (this.timeSeries != null ? !this.timeSeries.equals(meanModel.timeSeries) : meanModel.timeSeries != null) {
            return false;
        }
        return this.fittedSeries != null ? this.fittedSeries.equals(meanModel.fittedSeries) : meanModel.fittedSeries == null;
    }

    public int hashCode() {
        int result = this.timeSeries != null ? this.timeSeries.hashCode() : 0;
        result = 31 * result + (this.fittedSeries != null ? this.fittedSeries.hashCode() : 0);
        long temp = Double.doubleToLongBits(this.mean);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

