/*
 * Decompiled with CFR 0.152.
 */
package timeseries.models;

import data.Plots;
import timeseries.TimeSeries;
import timeseries.models.Forecast;

public interface Model {
    public TimeSeries pointForecast(int var1);

    public Forecast forecast(int var1, double var2);

    default public Forecast forecast(int steps) {
        return this.forecast(steps, 0.05);
    }

    public TimeSeries timeSeries();

    public TimeSeries fittedSeries();

    public TimeSeries residuals();

    default public void plotFit() {
        Plots.plot(this.fittedSeries(), "Model Fitted Values", "fitted values");
    }

    default public void plotResiduals() {
        Plots.plot(this.residuals(), "Model Residuals", "residuals");
    }
}

