/*
 * Decompiled with CFR 0.152.
 */
package timeseries.models;

import java.time.OffsetDateTime;
import lombok.NonNull;
import stats.distributions.Distribution;
import stats.distributions.Normal;
import timeseries.TimePeriod;
import timeseries.TimeSeries;
import timeseries.models.Forecast;
import timeseries.models.Model;
import timeseries.models.RandomWalkForecast;

public final class RandomWalk
implements Model {
    private final TimeSeries timeSeries;
    private final TimeSeries fittedSeries;
    private final TimeSeries residuals;

    public RandomWalk(@NonNull TimeSeries observed) {
        if (observed == null) {
            throw new NullPointerException("observed");
        }
        if (observed.n() < 1) {
            throw new IllegalArgumentException("A random walk model requires at least one observation.");
        }
        this.timeSeries = observed;
        this.fittedSeries = this.fitSeries();
        this.residuals = this.calculateResiduals();
    }

    public static TimeSeries simulate(@NonNull Distribution dist, int n) {
        if (dist == null) {
            throw new NullPointerException("dist");
        }
        if (n < 1) {
            throw new IllegalArgumentException("the number of observations to simulate must be a positive integer.");
        }
        double[] series = new double[n];
        series[0] = dist.rand();
        for (int t = 1; t < n; ++t) {
            series[t] = series[t - 1] + dist.rand();
        }
        return new TimeSeries(series);
    }

    public static TimeSeries simulate(double mean, double sigma, int n) {
        Normal dist = new Normal(mean, sigma);
        return RandomWalk.simulate(dist, n);
    }

    public static TimeSeries simulate(double sigma, int n) {
        Normal dist = new Normal(0.0, sigma);
        return RandomWalk.simulate(dist, n);
    }

    public static TimeSeries simulate(int n) {
        Normal dist = new Normal(0.0, 1.0);
        return RandomWalk.simulate(dist, n);
    }

    @Override
    public TimeSeries pointForecast(int steps) {
        int n = this.timeSeries.n();
        TimePeriod timePeriod = this.timeSeries.timePeriod();
        OffsetDateTime startTime = this.timeSeries.observationTimes().get(n - 1).plus(timePeriod.periodLength() * timePeriod.timeUnit().unitLength(), timePeriod.timeUnit().temporalUnit());
        double[] forecast = new double[steps];
        for (int t = 0; t < steps; ++t) {
            forecast[t] = this.timeSeries.at(n - 1);
        }
        return new TimeSeries(timePeriod, startTime, forecast);
    }

    @Override
    public Forecast forecast(int steps, double alpha) {
        return new RandomWalkForecast(this, steps, alpha);
    }

    @Override
    public TimeSeries timeSeries() {
        return this.timeSeries;
    }

    @Override
    public TimeSeries fittedSeries() {
        return this.fittedSeries;
    }

    @Override
    public TimeSeries residuals() {
        return this.residuals;
    }

    private TimeSeries fitSeries() {
        double[] fitted = new double[this.timeSeries.n()];
        fitted[0] = this.timeSeries.at(0);
        for (int t = 1; t < this.timeSeries.n(); ++t) {
            fitted[t] = this.timeSeries.at(t - 1);
        }
        return new TimeSeries(this.timeSeries.timePeriod(), this.timeSeries.observationTimes().get(0), fitted);
    }

    private TimeSeries calculateResiduals() {
        double[] residuals = new double[this.timeSeries.n()];
        for (int t = 1; t < this.timeSeries.n(); ++t) {
            residuals[t] = this.timeSeries.at(t) - this.fittedSeries.at(t);
        }
        return new TimeSeries(this.timeSeries.timePeriod(), this.timeSeries.observationTimes().get(0), residuals);
    }

    public String toString() {
        return "Random walk time series model";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RandomWalk that = (RandomWalk)o;
        if (this.timeSeries != null ? !this.timeSeries.equals(that.timeSeries) : that.timeSeries != null) {
            return false;
        }
        if (!this.fittedSeries.equals(that.fittedSeries)) {
            return false;
        }
        return this.residuals.equals(that.residuals);
    }

    public int hashCode() {
        int result = this.timeSeries != null ? this.timeSeries.hashCode() : 0;
        result = 31 * result + this.fittedSeries.hashCode();
        result = 31 * result + this.residuals.hashCode();
        return result;
    }
}

