/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.mavenplugin;

import com.github.kongchen.swagger.docgen.AbstractDocumentSource;
import com.github.kongchen.swagger.docgen.GenerateException;
import com.github.kongchen.swagger.docgen.mavenplugin.ApiSource;
import com.github.kongchen.swagger.docgen.reader.AbstractReader;
import com.github.kongchen.swagger.docgen.reader.ClassSwaggerReader;
import com.github.kongchen.swagger.docgen.reader.JaxrsReader;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.ws.rs.Path;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class MavenDocumentSource
extends AbstractDocumentSource {
    public MavenDocumentSource(ApiSource apiSource, Log log, String encoding) throws MojoFailureException {
        super(log, apiSource);
        if (encoding != null) {
            this.encoding = encoding;
        }
    }

    @Override
    protected Set<Class<?>> getValidClasses() {
        return Sets.union(super.getValidClasses(), this.apiSource.getValidClasses(Path.class));
    }

    @Override
    protected ClassSwaggerReader resolveApiReader() throws GenerateException {
        String customReaderClassName = this.apiSource.getSwaggerApiReader();
        if (customReaderClassName == null) {
            JaxrsReader reader = new JaxrsReader(this.swagger, this.LOG);
            reader.setTypesToSkip(this.typesToSkip);
            reader.setOperationIdFormat(this.apiSource.getOperationIdFormat());
            return reader;
        }
        ClassSwaggerReader customApiReader = this.getCustomApiReader(customReaderClassName);
        if (customApiReader instanceof AbstractReader) {
            ((AbstractReader)((Object)customApiReader)).setOperationIdFormat(this.apiSource.getOperationIdFormat());
        }
        return customApiReader;
    }
}

