/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.SpanCollectorMetricsHandler;
import com.github.kristofa.brave.internal.Nullable;
import com.twitter.zipkin.gen.Span;
import com.twitter.zipkin.gen.SpanCodec;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class AbstractSpanCollector
implements SpanCollector,
Flushable,
Closeable {
    private final SpanCodec codec;
    private final SpanCollectorMetricsHandler metrics;
    private final BlockingQueue<Span> pending = new LinkedBlockingQueue<Span>(1000);
    @Nullable
    private final Flusher flusher;

    public AbstractSpanCollector(SpanCodec codec, SpanCollectorMetricsHandler metrics, int flushInterval) {
        this.codec = codec;
        this.metrics = metrics;
        this.flusher = flushInterval > 0 ? new Flusher(this, flushInterval) : null;
    }

    @Override
    public void collect(Span span) {
        this.metrics.incrementAcceptedSpans(1);
        if (!this.pending.offer(span)) {
            this.metrics.incrementDroppedSpans(1);
        }
    }

    @Override
    public void flush() {
        byte[] encoded;
        if (this.pending.isEmpty()) {
            return;
        }
        ArrayList<Span> drained = new ArrayList<Span>(this.pending.size());
        this.pending.drainTo(drained);
        if (drained.isEmpty()) {
            return;
        }
        int spanCount = drained.size();
        try {
            encoded = this.codec.writeSpans(drained);
        }
        catch (RuntimeException e) {
            this.metrics.incrementDroppedSpans(spanCount);
            return;
        }
        try {
            this.sendSpans(encoded);
        }
        catch (IOException e) {
            this.metrics.incrementDroppedSpans(spanCount);
            return;
        }
    }

    protected abstract void sendSpans(byte[] var1) throws IOException;

    @Override
    public void addDefaultAnnotation(String key, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (this.flusher != null) {
            this.flusher.scheduler.shutdown();
        }
        int dropped = this.pending.drainTo(new LinkedList());
        this.metrics.incrementDroppedSpans(dropped);
    }

    static final class Flusher
    implements Runnable {
        final Flushable flushable;
        final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

        Flusher(Flushable flushable, int flushInterval) {
            this.flushable = flushable;
            this.scheduler.scheduleWithFixedDelay(this, 0L, flushInterval, TimeUnit.SECONDS);
        }

        @Override
        public void run() {
            try {
                this.flushable.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

