/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.AnnotationSubmitter;
import com.github.kristofa.brave.ClientRequestInterceptor;
import com.github.kristofa.brave.ClientResponseInterceptor;
import com.github.kristofa.brave.ClientSpanThreadBinder;
import com.github.kristofa.brave.ClientTracer;
import com.github.kristofa.brave.InetAddressUtilities;
import com.github.kristofa.brave.LocalTracer;
import com.github.kristofa.brave.LoggingSpanCollector;
import com.github.kristofa.brave.Sampler;
import com.github.kristofa.brave.ServerClientAndLocalSpanState;
import com.github.kristofa.brave.ServerRequestInterceptor;
import com.github.kristofa.brave.ServerResponseInterceptor;
import com.github.kristofa.brave.ServerSpanThreadBinder;
import com.github.kristofa.brave.ServerTracer;
import com.github.kristofa.brave.SpanAndEndpoint;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.ThreadLocalServerClientAndLocalSpanState;
import com.github.kristofa.brave.TraceFilter;
import com.github.kristofa.brave.internal.Util;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Random;

public class Brave {
    private final ServerTracer serverTracer;
    private final ClientTracer clientTracer;
    private final LocalTracer localTracer;
    private final ServerRequestInterceptor serverRequestInterceptor;
    private final ServerResponseInterceptor serverResponseInterceptor;
    private final ClientRequestInterceptor clientRequestInterceptor;
    private final ClientResponseInterceptor clientResponseInterceptor;
    private final AnnotationSubmitter serverSpanAnnotationSubmitter;
    private final ServerSpanThreadBinder serverSpanThreadBinder;
    private final ClientSpanThreadBinder clientSpanThreadBinder;

    public ClientTracer clientTracer() {
        return this.clientTracer;
    }

    public LocalTracer localTracer() {
        return this.localTracer;
    }

    public ServerTracer serverTracer() {
        return this.serverTracer;
    }

    public ClientRequestInterceptor clientRequestInterceptor() {
        return this.clientRequestInterceptor;
    }

    public ClientResponseInterceptor clientResponseInterceptor() {
        return this.clientResponseInterceptor;
    }

    public ServerRequestInterceptor serverRequestInterceptor() {
        return this.serverRequestInterceptor;
    }

    public ServerResponseInterceptor serverResponseInterceptor() {
        return this.serverResponseInterceptor;
    }

    public ServerSpanThreadBinder serverSpanThreadBinder() {
        return this.serverSpanThreadBinder;
    }

    public ClientSpanThreadBinder clientSpanThreadBinder() {
        return this.clientSpanThreadBinder;
    }

    public AnnotationSubmitter serverSpanAnnotationSubmitter() {
        return this.serverSpanAnnotationSubmitter;
    }

    private Brave(Builder builder) {
        this.serverTracer = ServerTracer.builder().randomGenerator(builder.random).spanCollector(builder.spanCollector).state(builder.state).traceSampler(builder.sampler).build();
        this.clientTracer = ClientTracer.builder().randomGenerator(builder.random).spanCollector(builder.spanCollector).state(builder.state).traceSampler(builder.sampler).build();
        this.localTracer = LocalTracer.builder().randomGenerator(builder.random).spanCollector(builder.spanCollector).spanAndEndpoint(SpanAndEndpoint.LocalSpanAndEndpoint.create(builder.state)).traceSampler(builder.sampler).build();
        this.serverRequestInterceptor = new ServerRequestInterceptor(this.serverTracer);
        this.serverResponseInterceptor = new ServerResponseInterceptor(this.serverTracer);
        this.clientRequestInterceptor = new ClientRequestInterceptor(this.clientTracer);
        this.clientResponseInterceptor = new ClientResponseInterceptor(this.clientTracer);
        this.serverSpanAnnotationSubmitter = AnnotationSubmitter.create(SpanAndEndpoint.ServerSpanAndEndpoint.create(builder.state));
        this.serverSpanThreadBinder = new ServerSpanThreadBinder(builder.state);
        this.clientSpanThreadBinder = new ClientSpanThreadBinder(builder.state);
    }

    public static class Builder {
        private final ServerClientAndLocalSpanState state;
        private SpanCollector spanCollector = new LoggingSpanCollector();
        private Random random = new Random();
        private Sampler sampler = Sampler.create(1.0f);

        public Builder() {
            this("unknown");
        }

        public Builder(String serviceName) {
            try {
                int ip = InetAddressUtilities.toInt(InetAddressUtilities.getLocalHostLANAddress());
                this.state = new ThreadLocalServerClientAndLocalSpanState(ip, 0, serviceName);
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException("Unable to get Inet address", e);
            }
        }

        public Builder(int ip, int port, String serviceName) {
            this.state = new ThreadLocalServerClientAndLocalSpanState(ip, port, serviceName);
        }

        public Builder(ServerClientAndLocalSpanState state) {
            this.state = Util.checkNotNull(state, "state must be specified.", new Object[0]);
        }

        @Deprecated
        public Builder traceFilters(List<TraceFilter> ignored) {
            return this;
        }

        public Builder traceSampler(Sampler sampler) {
            this.sampler = sampler;
            return this;
        }

        public Builder spanCollector(SpanCollector spanCollector) {
            this.spanCollector = spanCollector;
            return this;
        }

        public Brave build() {
            return new Brave(this);
        }
    }
}

